/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.ConsoleObject;
import adams.core.DateTime;
import adams.core.Stoppable;
import adams.core.Utils;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.ColumnNameConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.db.SQL;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

public class SqlUtils {
    public static Cell.ContentType sqlTypeToContentType(int colType) {
        switch (colType) {
            case 92: {
                return Cell.ContentType.TIME;
            }
            case 91: {
                return Cell.ContentType.DATE;
            }
            case 93: {
                return Cell.ContentType.DATETIME;
            }
            case 4: {
                return Cell.ContentType.LONG;
            }
            case -5: {
                return Cell.ContentType.LONG;
            }
            case 6: {
                return Cell.ContentType.DOUBLE;
            }
            case 8: {
                return Cell.ContentType.DOUBLE;
            }
        }
        return Cell.ContentType.STRING;
    }

    public static int contentTypeToSqlType(Cell.ContentType contentType) {
        switch (contentType) {
            case DATE: {
                return 91;
            }
            case DATETIME: {
                return 93;
            }
            case TIME: {
                return 92;
            }
            case DOUBLE: {
                return 8;
            }
            case LONG: {
                return 4;
            }
            case BOOLEAN: {
                return 16;
            }
        }
        return 12;
    }

    public static class Reader
    extends ConsoleObject
    implements Stoppable {
        private static final long serialVersionUID = -958340824375198629L;
        protected Class m_RowClass;
        protected boolean m_Finished;
        protected boolean m_Stopped;
        protected SpreadSheet m_Header;
        protected int[] m_Type;

        public Reader(Class rowClass) {
            if (rowClass == null) {
                throw new IllegalArgumentException("No row class specified!");
            }
            this.m_RowClass = rowClass;
            this.m_Header = null;
            this.m_Type = new int[0];
        }

        public void initHeader(ResultSet rs) throws SQLException {
            SpreadSheet result = new SpreadSheet();
            result.setDataRowClass(this.getRowClass());
            HeaderRow row = result.getHeaderRow();
            this.m_Type = SQL.getColumnTypes((ResultSet)rs);
            String[] names = SQL.getColumnNames((ResultSet)rs);
            for (int i = 1; i <= names.length; ++i) {
                row.addCell("" + i).setContentAsString(names[i - 1]);
            }
            this.m_Header = result.getHeader();
        }

        public Class getRowClass() {
            return this.m_RowClass;
        }

        public SpreadSheet getHeader() {
            return this.m_Header;
        }

        public SpreadSheet read(ResultSet rs) throws SQLException {
            return this.read(rs, -1);
        }

        public SpreadSheet read(ResultSet rs, int max) throws SQLException {
            this.m_Stopped = false;
            this.m_Finished = false;
            if (this.m_Header == null) {
                this.initHeader(rs);
                this.m_Finished = !rs.next();
            }
            SpreadSheet result = this.m_Header.getHeader();
            while (!this.m_Finished && !this.m_Stopped) {
                DataRow row = result.addRow();
                for (int i = 1; i <= result.getColumnCount(); ++i) {
                    Cell.ContentType type = SqlUtils.sqlTypeToContentType(this.m_Type[i - 1]);
                    switch (type) {
                        case TIME: {
                            row.addCell(i - 1).setContent((java.util.Date)rs.getTime(i));
                            break;
                        }
                        case DATE: {
                            row.addCell(i - 1).setContent((java.util.Date)rs.getDate(i));
                            break;
                        }
                        case DATETIME: {
                            row.addCell(i - 1).setContent(new DateTime((java.util.Date)rs.getTimestamp(i)));
                            break;
                        }
                        case LONG: {
                            row.addCell(i - 1).setContent(Long.valueOf(rs.getLong(i)));
                            break;
                        }
                        case DOUBLE: {
                            row.addCell(i - 1).setContent(Double.valueOf(rs.getDouble(i)));
                            break;
                        }
                        case STRING: {
                            row.addCell(i - 1).setContent(rs.getString(i));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled content type: " + type);
                        }
                    }
                    if (!rs.wasNull()) continue;
                    row.getCell(i - 1).setMissing();
                }
                boolean bl = this.m_Finished = !rs.next();
                if (max <= 0 || result.getRowCount() != max) continue;
            }
            if (this.m_Finished || this.m_Stopped) {
                SQL.closeAll((ResultSet)rs);
            }
            return result;
        }

        public void stopExecution() {
            this.m_Stopped = true;
        }

        public boolean isStopped() {
            return this.m_Stopped;
        }

        public boolean isFinished() {
            return this.m_Finished;
        }
    }

    public static class Writer
    extends ConsoleObject
    implements Stoppable {
        private static final long serialVersionUID = 1094278005436201843L;
        public static final String PLACEHOLDER_MAX = "@MAX";
        protected SpreadSheet m_Sheet;
        protected String m_Table;
        protected Cell.ContentType[] m_ContentTypes;
        protected int m_MaxColumnLength;
        protected String[] m_ColumnNames;
        protected ColumnNameConversion m_ColumnNameConversion;
        protected String m_StringColumnSQL;
        protected int m_MaxStringLength;
        protected boolean m_Stopped;

        public Writer(SpreadSheet sheet, String table, int maxCol, ColumnNameConversion colName, String stringCol, int maxStr) {
            this.m_Sheet = sheet;
            this.m_Table = table;
            this.m_MaxColumnLength = maxCol;
            this.m_ColumnNameConversion = colName;
            this.m_StringColumnSQL = stringCol;
            this.m_MaxStringLength = maxStr;
            this.generate();
        }

        protected void generate() {
            int i;
            this.m_ContentTypes = new Cell.ContentType[this.m_Sheet.getColumnCount()];
            for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                this.m_ContentTypes[i] = Cell.ContentType.STRING;
                if (this.m_Sheet.isNumeric(i)) {
                    this.m_ContentTypes[i] = Cell.ContentType.DOUBLE;
                    Collection types = this.m_Sheet.getContentTypes(i);
                    if (types.size() != 1 || !types.contains(Cell.ContentType.LONG)) continue;
                    this.m_ContentTypes[i] = Cell.ContentType.LONG;
                    continue;
                }
                Cell.ContentType type = this.m_Sheet.getContentType(i);
                if (type == null) {
                    type = Cell.ContentType.STRING;
                }
                switch (type) {
                    case TIME: 
                    case DATE: 
                    case DATETIME: {
                        this.m_ContentTypes[i] = type;
                    }
                }
            }
            this.m_ColumnNames = new String[this.m_Sheet.getColumnCount()];
            HashSet<String> names = new HashSet<String>();
            for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                String name = this.m_Sheet.getHeaderRow().getCell(i).getContent();
                String prefix = name = this.fixColumnName(name);
                int count = 0;
                while (names.contains(name)) {
                    if (new String(prefix + ++count).length() > this.m_MaxColumnLength) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    name = prefix + count;
                }
                names.add(name);
                this.m_ColumnNames[i] = name;
            }
        }

        public String getTable() {
            return this.m_Table;
        }

        public ColumnNameConversion getColumnNameConversion() {
            return this.m_ColumnNameConversion;
        }

        public int getMaxStringLength() {
            return this.m_MaxStringLength;
        }

        public String getStringColumnSQL() {
            return this.m_StringColumnSQL;
        }

        protected String fixColumnName(String s) {
            String result = "";
            for (int i = 0; i < s.length(); ++i) {
                char chr = s.charAt(i);
                if (chr >= 'A' && chr <= 'Z') {
                    result = result + chr;
                } else if (chr >= 'a' && chr <= 'z') {
                    result = result + chr;
                }
                if (i < 0) continue;
                if (chr >= '0' && chr <= '9') {
                    result = result + chr;
                    continue;
                }
                if (chr != '_') continue;
                result = result + chr;
            }
            if (result.length() > this.m_MaxColumnLength) {
                result = result.substring(0, this.m_MaxColumnLength);
            }
            switch (this.m_ColumnNameConversion) {
                case AS_IS: {
                    break;
                }
                case LOWER_CASE: {
                    result = result.toLowerCase();
                    break;
                }
                case UPPER_CASE: {
                    result = result.toUpperCase();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled conversion type: " + (Object)((Object)this.m_ColumnNameConversion));
                }
            }
            return result;
        }

        public String getCreateStatement() {
            String stringType = this.m_StringColumnSQL.replace(PLACEHOLDER_MAX, "" + this.m_MaxStringLength);
            StringBuilder result = new StringBuilder("CREATE TABLE " + this.m_Table + "(");
            block8: for (int i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                switch (this.m_ContentTypes[i]) {
                    case LONG: {
                        result.append(this.m_ColumnNames[i] + " INTEGER");
                        continue block8;
                    }
                    case DOUBLE: {
                        result.append(this.m_ColumnNames[i] + " DOUBLE PRECISION");
                        continue block8;
                    }
                    case DATE: {
                        result.append(this.m_ColumnNames[i] + " DATE");
                        continue block8;
                    }
                    case DATETIME: {
                        result.append(this.m_ColumnNames[i] + " TIMESTAMP");
                        continue block8;
                    }
                    case TIME: {
                        result.append(this.m_ColumnNames[i] + " TIME");
                        continue block8;
                    }
                    case BOOLEAN: {
                        result.append(this.m_ColumnNames[i] + " BOOLEAN");
                        continue block8;
                    }
                    default: {
                        result.append(this.m_ColumnNames[i] + " " + stringType);
                    }
                }
            }
            result.append(");");
            return result.toString();
        }

        public String getInsertStatement() {
            int i;
            StringBuilder result = new StringBuilder("INSERT INTO " + this.m_Table + "(");
            for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.m_ColumnNames[i]);
            }
            result.append(") VALUES (");
            for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append("?");
            }
            result.append(");");
            return result.toString();
        }

        public String[] getColumnNames() {
            return this.m_ColumnNames;
        }

        public Cell.ContentType[] getContentTypes() {
            return this.m_ContentTypes;
        }

        public String createTable(SQL sql) {
            String result = null;
            String query = this.getCreateStatement();
            try {
                Boolean rs = sql.execute(query);
                if (rs == null) {
                    result = "Failed to create table, check console!";
                }
            }
            catch (Exception e) {
                result = Utils.handleException((ConsoleObject)this, (String)("Failed to create table '" + this.m_Table + "' using: " + query), (Throwable)e);
            }
            return result;
        }

        public String writeData(SQL sql) {
            PreparedStatement stmt;
            int i;
            String result = null;
            StringBuilder query = new StringBuilder("INSERT INTO " + this.m_Table + "(");
            for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append(this.m_ColumnNames[i]);
            }
            query.append(") VALUES (");
            for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append("?");
            }
            query.append(");");
            try {
                stmt = sql.prepareStatement(query.toString());
            }
            catch (Exception e) {
                result = Utils.handleException((ConsoleObject)this, (String)("Failed to prepare statement: " + query), (Throwable)e);
                stmt = null;
            }
            if (result == null) {
                this.m_Stopped = false;
                int count = 0;
                for (DataRow row : this.m_Sheet.rows()) {
                    if (this.m_Stopped) break;
                    ++count;
                    try {
                        block15: for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                            Cell cell = row.getCell(i);
                            if (cell == null || cell.isMissing()) {
                                int type = SqlUtils.contentTypeToSqlType(this.m_ContentTypes[i]);
                                stmt.setNull(i + 1, type);
                                continue;
                            }
                            switch (this.m_ContentTypes[i]) {
                                case DATE: {
                                    stmt.setDate(i + 1, new Date(cell.toDate().getTime()));
                                    continue block15;
                                }
                                case DATETIME: {
                                    stmt.setTimestamp(i + 1, new Timestamp(cell.toDate().getTime()));
                                    continue block15;
                                }
                                case TIME: {
                                    stmt.setTime(i + 1, cell.toTime().toSql());
                                    continue block15;
                                }
                                case DOUBLE: {
                                    stmt.setDouble(i + 1, cell.toDouble());
                                    continue block15;
                                }
                                case LONG: {
                                    stmt.setInt(i + 1, cell.toLong().intValue());
                                    continue block15;
                                }
                                case BOOLEAN: {
                                    stmt.setBoolean(i + 1, cell.toBoolean());
                                    continue block15;
                                }
                                default: {
                                    String str = cell.getContent();
                                    if (str.length() > this.m_MaxStringLength) {
                                        str = str.substring(0, this.m_MaxStringLength);
                                    }
                                    stmt.setString(i + 1, str);
                                }
                            }
                        }
                        stmt.execute();
                    }
                    catch (Exception e) {
                        result = Utils.handleException((ConsoleObject)this, (String)("Failed to insert data: " + row + "\nusing: " + stmt), (Throwable)e);
                        break;
                    }
                    if (count % 1000 != 0) continue;
                    this.getSystemOut().println(count + " rows processed");
                }
            }
            SQL.close((Statement)stmt);
            return result;
        }

        public void stopExecution() {
            this.m_Stopped = true;
        }
    }
}

