/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.columnfinder;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.AbstractColumnFinder;
import adams.data.spreadsheet.columnfinder.TrainableColumnFinder;

public abstract class AbstractTrainableColumnFinder
extends AbstractColumnFinder
implements TrainableColumnFinder {
    private static final long serialVersionUID = 3800769979430280486L;
    protected boolean m_Trained;

    protected void reset() {
        super.reset();
        this.m_Trained = false;
    }

    protected abstract boolean doTrainColumnFinder(SpreadSheet var1);

    @Override
    public boolean trainColumnFinder(SpreadSheet data) {
        this.m_Trained = this.doTrainColumnFinder(data);
        if (this.isDebugOn()) {
            this.debug("Training success: " + this.m_Trained);
        }
        return this.m_Trained;
    }

    @Override
    public boolean isColumnFinderTrained() {
        return this.m_Trained;
    }

    @Override
    protected void check(SpreadSheet data) {
        super.check(data);
        if (!this.isColumnFinderTrained() && !this.trainColumnFinder(data)) {
            throw new IllegalStateException("Unable to train column finder!");
        }
    }
}

