/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.columnfinder;

import adams.core.Utils;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.AbstractColumnFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class ByContentType
extends AbstractColumnFinder {
    private static final long serialVersionUID = 2989233908194930918L;
    protected Cell.ContentType[] m_ContentTypes;

    public String globalInfo() {
        return "Returns the indices of columns that match any of the specified content types.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("content-type", "contentTypes", (Object)new Cell.ContentType[]{Cell.ContentType.DOUBLE});
    }

    public void setContentTypes(Cell.ContentType[] value) {
        this.m_ContentTypes = value;
        this.reset();
    }

    public Cell.ContentType[] getContentTypes() {
        return this.m_ContentTypes;
    }

    public String contentTypesTipText() {
        return "The content types that the columns can have.";
    }

    @Override
    protected int[] doFindColumns(SpreadSheet data) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        HashSet<Cell.ContentType> types = new HashSet<Cell.ContentType>(Arrays.asList(this.m_ContentTypes));
        for (int i = 0; i < data.getColumnCount(); ++i) {
            Cell.ContentType type = data.getContentType(i);
            if (!types.contains(type)) continue;
            result.add(i);
        }
        return Utils.toIntArray(result);
    }
}

