/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import adams.data.spreadsheet.rowfinder.TrainableRowFinder;

public abstract class AbstractTrainableRowFinder
extends AbstractRowFinder
implements TrainableRowFinder {
    private static final long serialVersionUID = 3800769979430280486L;
    protected boolean m_Trained;

    protected void reset() {
        super.reset();
        this.m_Trained = false;
    }

    protected abstract boolean doTrainRowFinder(SpreadSheet var1);

    @Override
    public boolean trainRowFinder(SpreadSheet data) {
        this.m_Trained = this.doTrainRowFinder(data);
        if (this.isDebugOn()) {
            this.debug("Training success: " + this.m_Trained);
        }
        return this.m_Trained;
    }

    @Override
    public boolean isRowFinderTrained() {
        return this.m_Trained;
    }

    @Override
    protected void check(SpreadSheet data) {
        super.check(data);
        if (!this.isRowFinderTrained() && !this.trainRowFinder(data)) {
            throw new IllegalStateException("Unable to train row finder!");
        }
    }
}

