/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.Utils;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import java.util.ArrayList;

public class MissingValue
extends AbstractRowFinder {
    private static final long serialVersionUID = 2163229604979216233L;
    protected SpreadSheetColumnRange m_AttributeRange;

    public String globalInfo() {
        return "Returns the indices of rows of columns which have missing values.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-range", "attributeRange", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public void setAttributeRange(SpreadSheetColumnRange value) {
        this.m_AttributeRange = value;
        this.reset();
    }

    public SpreadSheetColumnRange getAttributeRange() {
        return this.m_AttributeRange;
    }

    public String attributeRangeTipText() {
        return "The range of the columns to inspect; " + this.m_AttributeRange.getExample();
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        this.m_AttributeRange.setSpreadSheet(data);
        int[] indices = this.m_AttributeRange.getIntIndices();
        if (indices.length == 0) {
            throw new IllegalStateException("Invalid range '" + this.m_AttributeRange.getRange() + "'?");
        }
        block0: for (int i = 0; i < data.getRowCount(); ++i) {
            DataRow row = data.getRow(i);
            for (int index : indices) {
                if (row.hasCell(index) && !row.getCell(index).isMissing()) continue;
                result.add(i);
                continue block0;
            }
        }
        return Utils.toIntArray(result);
    }
}

