/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.LookUpInit;
import java.util.HashMap;

public class LookUpAdd
extends AbstractTransformer {
    private static final long serialVersionUID = 7602201480653131469L;
    protected StorageName m_StorageName;

    public String globalInfo() {
        return "Adds a key-value pair to the specified lookup table. \nThe input for the actor a string array of length 2, with the first element the key and the second one the value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    public Class[] accepts() {
        return new Class[]{String[].class};
    }

    public Class[] generates() {
        return new Class[]{String[].class};
    }

    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Lookup table '" + this.m_StorageName + "' not available! Not initialized with " + LookUpInit.class.getName() + "?";
        } else {
            HashMap lookup = (HashMap)this.getStorageHandler().getStorage().get(this.m_StorageName);
            String[] pair = (String[])this.m_InputToken.getPayload();
            if (pair.length != 2) {
                result = "String array must have length 2, provided: " + pair.length;
            } else {
                String key = pair[0];
                String value = pair[1];
                if (this.isDebugOn()) {
                    if (lookup.containsKey(key)) {
                        this.debug("Replacing: '" + key + "' -> '" + value + "'");
                    } else {
                        this.debug("Adding: '" + key + "' -> '" + value + "'");
                    }
                }
                lookup.put(key, value);
                this.m_OutputToken = this.m_InputToken;
            }
        }
        return result;
    }
}

