/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.Hashtable;

public class SpreadSheetReplaceCellValue
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = 2639196406457405487L;
    public static final String BACKUP_ACTUALREPLACE = "actual replace";
    protected BaseRegExp m_Find;
    protected String m_Replace;
    protected String m_ActualReplace;
    protected boolean m_ReplaceAll;
    protected boolean m_ReplaceContainsPlaceholder;
    protected boolean m_ReplaceContainsVariable;
    protected Scope m_Scope;

    public String globalInfo() {
        return "Replaces cell values that match a regular expression with a predefined value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("find", "find", (Object)new BaseRegExp("find"));
        this.m_OptionManager.add("replace", "replace", (Object)"");
        this.m_OptionManager.add("all", "replaceAll", (Object)false);
        this.m_OptionManager.add("placeholder", "replaceContainsPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "replaceContainsVariable", (Object)false);
        this.m_OptionManager.add("scope", "scope", (Object)Scope.DATA_ONLY);
    }

    public String getQuickInfo() {
        String find;
        String replace = QuickInfoHelper.toString((OptionHandler)this, (String)"replace", (Object)this.m_Replace);
        if (replace == null) {
            replace = "";
        }
        if ((find = QuickInfoHelper.toString((OptionHandler)this, (String)"find", (BaseRegExp)this.m_Find)) == null) {
            find = "";
        }
        String result = replace.length() > 0 ? "replace " : "remove ";
        result = result + "'" + find + "'";
        if (replace.length() > 0) {
            result = result + " with '" + replace + "'";
        }
        result = result + " (" + QuickInfoHelper.toString((OptionHandler)this, (String)"scope", (Object)((Object)this.m_Scope)) + ")";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setFind(BaseRegExp value) {
        this.m_Find = value;
        this.reset();
    }

    public BaseRegExp getFind() {
        return this.m_Find;
    }

    public String findTipText() {
        return "The string to find (a regular expression).";
    }

    public void setReplace(String value) {
        this.m_Replace = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getReplace() {
        return Utils.backQuoteChars((String)this.m_Replace);
    }

    public String replaceTipText() {
        return "The string to replace the occurrences with.";
    }

    public void setReplaceAll(boolean value) {
        this.m_ReplaceAll = value;
        this.reset();
    }

    public boolean getReplaceAll() {
        return this.m_ReplaceAll;
    }

    public String replaceAllTipText() {
        return "If set to true, then all occurrences will be replaced; otherwise only the first.";
    }

    public void setReplaceContainsPlaceholder(boolean value) {
        this.m_ReplaceContainsPlaceholder = value;
        this.reset();
    }

    public boolean getReplaceContainsPlaceholder() {
        return this.m_ReplaceContainsPlaceholder;
    }

    public String replaceContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the replacement string.";
    }

    public void setReplaceContainsVariable(boolean value) {
        this.m_ReplaceContainsVariable = value;
        this.reset();
    }

    public boolean getReplaceContainsVariable() {
        return this.m_ReplaceContainsVariable;
    }

    public String replaceContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the replacement string.";
    }

    public void setScope(Scope value) {
        this.m_Scope = value;
        this.reset();
    }

    public Scope getScope() {
        return this.m_Scope;
    }

    public String scopeTipText() {
        return "Determines the scope of the find/replace action.";
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ACTUALREPLACE);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_ACTUALREPLACE, this.m_ActualReplace);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ACTUALREPLACE)) {
            this.m_ActualReplace = (String)state.get(BACKUP_ACTUALREPLACE);
            state.remove(BACKUP_ACTUALREPLACE);
        }
        super.restoreState(state);
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActualReplace = this.m_Replace;
            if (this.m_ReplaceContainsPlaceholder) {
                this.m_ActualReplace = Placeholders.getSingleton().expand(this.m_ActualReplace).replace("\\", "/");
            }
        }
        return result;
    }

    protected String process(String s) {
        String replace = this.m_ActualReplace;
        if (this.m_ReplaceContainsVariable) {
            replace = this.getVariables().expand(replace);
        }
        if (this.m_ReplaceAll) {
            return s.replaceAll(this.m_Find.getValue(), replace);
        }
        return s.replaceFirst(this.m_Find.getValue(), replace);
    }

    protected String doExecute() {
        String newValue;
        String curValue;
        int n;
        HeaderRow row;
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet updated = this.m_NoCopy ? sheet : sheet.getClone();
        boolean modified = false;
        if (this.m_Scope == Scope.HEADER_AND_DATA || this.m_Scope == Scope.HEADER_ONLY) {
            row = updated.getHeaderRow();
            for (n = 0; n < row.getCellCount(); ++n) {
                curValue = row.getCell(n).getContent();
                newValue = this.process(curValue);
                if (newValue.equals(curValue)) continue;
                row.getCell(n).setContent(newValue);
                modified = true;
            }
        }
        if (this.m_Scope == Scope.HEADER_AND_DATA || this.m_Scope == Scope.DATA_ONLY) {
            for (int i = 0; i < updated.getRowCount(); ++i) {
                row = updated.getRow(i);
                for (n = 0; n < row.getCellCount(); ++n) {
                    curValue = row.getCell(n).getContent();
                    newValue = this.process(curValue);
                    if (newValue.equals(curValue)) continue;
                    row.getCell(n).setContent(newValue);
                    modified = true;
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("Spreadsheet modified: " + modified);
        }
        this.m_OutputToken = new Token((Object)updated);
        return result;
    }

    public static enum Scope {
        DATA_ONLY,
        HEADER_ONLY,
        HEADER_AND_DATA;

    }
}

