/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;

public class SpreadSheetSetCell
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = -6250232085303020849L;
    protected Index m_Row;
    protected SpreadSheetColumnIndex m_Column;
    protected String m_Value;
    protected boolean m_ForceString;

    public String globalInfo() {
        return "Sets a single cell value in a spreadsheet.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Index("1"));
        this.m_OptionManager.add("col", "column", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("value", "value", (Object)"");
        this.m_OptionManager.add("force-string", "forceString", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Row = new Index();
        this.m_Column = new SpreadSheetColumnIndex();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)this.m_Row, (String)"row: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"/col: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)("'" + this.m_Value + "'"), (String)", value: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"forceString", (boolean)this.m_ForceString, (String)"force string", (String)", ");
        return result;
    }

    public void setRow(Index value) {
        this.m_Row = value;
        this.reset();
    }

    public Index getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row of the cell to set; " + this.m_Row.getExample();
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column of the cell to set; " + this.m_Column.getExample();
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set in the cell.";
    }

    public void setForceString(boolean value) {
        this.m_ForceString = value;
        this.reset();
    }

    public boolean getForceString() {
        return this.m_ForceString;
    }

    public String forceStringTipText() {
        return "If enabled, the value is set as string, even if it resembles a number.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        if (!this.m_NoCopy) {
            sheet = sheet.getClone();
        }
        this.m_Row.setMax(sheet.getRowCount());
        this.m_Column.setSpreadSheet(sheet);
        if (this.m_Row.getIntIndex() == -1) {
            result = "Illegal row index ('" + this.m_Row.getIndex() + "')?";
        } else if (this.m_Column.getIntIndex() == -1) {
            result = "Illegal column index ('" + this.m_Column.getIndex() + "')?";
        } else {
            DataRow row = sheet.getRow(this.m_Row.getIntIndex());
            Cell cell = row.getCell(this.m_Column.getIntIndex());
            if (cell == null) {
                cell = row.addCell(this.m_Column.getIntIndex());
            }
            if (this.m_ForceString) {
                cell.setContentAsString(this.m_Value);
            } else {
                cell.setContent(this.m_Value);
            }
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

