/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateTime;
import adams.core.QuickInfoHelper;
import adams.core.Time;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.AbstractCellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.CellRange;
import adams.event.VariableChangeListener;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Compatibility;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.GlobalActorUser;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class SpreadSheetTransformCells
extends AbstractInPlaceSpreadSheetTransformer
implements GlobalActorUser {
    private static final long serialVersionUID = -2533024333073383813L;
    public static final String BACKUP_GLOBALACTOR = "global actor";
    protected AbstractCellFinder m_Finder;
    protected GlobalActorReference m_Transformer;
    protected GlobalActorHelper m_Helper;
    protected AbstractActor m_GlobalActor;

    public String globalInfo() {
        return "Finds cells in a spreadsheet and transforms them with a global transformer.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new CellRange());
        this.m_OptionManager.add("transformer", "transformer", (Object)new GlobalActorReference("unknown"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new GlobalActorHelper();
    }

    protected void reset() {
        super.reset();
        this.m_GlobalActor = null;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)((Object)this.m_Finder), (String)"finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"transformer", (Object)this.m_Transformer, (String)", transformer: ");
        return result;
    }

    public void setFinder(AbstractCellFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public AbstractCellFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The cell finder to use.";
    }

    public void setTransformer(GlobalActorReference value) {
        this.m_Transformer = value;
        this.reset();
    }

    public GlobalActorReference getTransformer() {
        return this.m_Transformer;
    }

    public String transformerTipText() {
        return "The global transformer to apply to the located cells.";
    }

    protected AbstractActor findGlobalActor() {
        return this.m_Helper.findGlobalActorRecursive((AbstractActor)this, this.getTransformer());
    }

    public boolean hasGlobalActor() {
        return this.m_GlobalActor != null;
    }

    public AbstractActor getGlobalActor() {
        return this.m_GlobalActor;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_GLOBALACTOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_GlobalActor != null) {
            result.put(BACKUP_GLOBALACTOR, this.m_GlobalActor);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_GLOBALACTOR)) {
            this.m_GlobalActor = (AbstractActor)state.get(BACKUP_GLOBALACTOR);
            state.remove(BACKUP_GLOBALACTOR);
        }
    }

    protected String setUpGlobalActor() {
        String result = null;
        this.m_GlobalActor = this.findGlobalActor();
        if (this.m_GlobalActor == null) {
            result = "Couldn't find global transformer '" + this.getTransformer() + "'!";
        } else if (ActorUtils.isTransformer((AbstractActor)this.m_GlobalActor)) {
            HashSet variables = this.findVariables(this.m_GlobalActor);
            this.m_DetectedVariables.addAll(variables);
            if (this.m_DetectedVariables.size() > 0) {
                this.getVariables().addVariableChangeListener((VariableChangeListener)this);
            }
        } else {
            result = "Global actor '" + this.getTransformer() + "' is not a transformer!";
        }
        return result;
    }

    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("transformer")) == null) {
            result = this.setUpGlobalActor();
        }
        return result;
    }

    protected String transformCell(CellLocation location, SpreadSheet sheet) {
        if (!sheet.hasCell(location.getRow(), location.getColumn())) {
            return null;
        }
        String result = null;
        Cell cell = sheet.getCell(location.getRow(), location.getColumn());
        Object input = null;
        Object output = null;
        Class[] classIn = ((InputConsumer)this.m_GlobalActor).accepts();
        Class[] classOut = ((OutputProducer)this.m_GlobalActor).generates();
        Compatibility comp = new Compatibility();
        if (comp.isCompatible(new Class[]{Double.class}, classIn)) {
            input = cell.toDouble();
        } else if (comp.isCompatible(new Class[]{Integer.class}, classIn)) {
            input = cell.toLong().intValue();
        } else if (comp.isCompatible(new Class[]{Long.class}, classIn)) {
            input = cell.toLong();
        } else if (comp.isCompatible(new Class[]{Date.class}, classIn)) {
            input = cell.toDate();
        } else if (comp.isCompatible(new Class[]{DateTime.class}, classIn)) {
            input = cell.toDateTime();
        } else if (comp.isCompatible(new Class[]{Time.class}, classIn)) {
            input = cell.toTime();
        } else if (comp.isCompatible(new Class[]{String.class}, classIn)) {
            input = cell.getContent();
        } else {
            result = "Don't know how to get cell value for conversion input type: " + Utils.arrayToString((Object)classIn);
        }
        if (result == null) {
            ((InputConsumer)this.m_GlobalActor).input(new Token(input));
            result = this.m_GlobalActor.execute();
        }
        if (result == null) {
            output = ((OutputProducer)this.m_GlobalActor).output();
            if (output != null) {
                output = output.getPayload();
            }
            if (comp.isCompatible(classOut, new Class[]{Double.class})) {
                cell.setContent((Double)output);
            } else if (comp.isCompatible(classOut, new Class[]{Integer.class})) {
                cell.setContent((Integer)output);
            } else if (comp.isCompatible(classOut, new Class[]{Long.class})) {
                cell.setContent((Long)output);
            } else if (comp.isCompatible(classOut, new Class[]{Date.class})) {
                cell.setContent((Date)output);
            } else if (comp.isCompatible(classOut, new Class[]{DateTime.class})) {
                cell.setContent((DateTime)output);
            } else if (comp.isCompatible(classOut, new Class[]{Time.class})) {
                cell.setContent((Time)output);
            } else if (comp.isCompatible(classOut, new Class[]{String.class})) {
                cell.setContent((String)output);
            } else {
                result = "Don't know how to set cell value for conversion output type: " + Utils.arrayToString((Object)classOut);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        if (this.m_GlobalActor == null) {
            result = this.setUpGlobalActor();
        }
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        Iterator<CellLocation> cells = this.m_Finder.findCells(sheetNew);
        if (!(this.m_GlobalActor.getSkip() || this.m_GlobalActor.isStopped() || this.m_Stopped)) {
            AbstractActor abstractActor = this.m_GlobalActor;
            synchronized (abstractActor) {
                while (cells.hasNext() && (result = this.transformCell(cells.next(), sheetNew)) == null) {
                }
            }
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)sheetNew);
        }
        return result;
    }
}

