/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.SortableTableModel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.sendto.AbstractSendToAction;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.io.File;
import javax.swing.JTable;

public class ExportAsSpreadsheet
extends AbstractSendToAction {
    private static final long serialVersionUID = -5286281737195775697L;

    public String getAction() {
        return "Export as spreadsheet";
    }

    public String getIconName() {
        return "spreadsheet.png";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class, JTable.class};
    }

    public String send(Object o) {
        String result = null;
        SpreadSheet sheet = null;
        if (o instanceof SpreadSheet) {
            sheet = (SpreadSheet)o;
        } else if (o instanceof SpreadSheetTable) {
            sheet = ((SpreadSheetTable)o).toSpreadSheet();
        } else if (o instanceof JTable) {
            JTable table = (JTable)o;
            if (table.getModel() instanceof SpreadSheetTableModel) {
                sheet = ((SpreadSheetTableModel)table.getModel()).toSpreadSheet();
            } else if (table.getModel() instanceof SortableTableModel && (SortableTableModel)table.getModel() instanceof SpreadSheetTableModel) {
                sheet = ((SpreadSheetTableModel)((SortableTableModel)table.getModel()).getUnsortedModel()).toSpreadSheet();
            }
            if (sheet == null) {
                int i;
                sheet = new SpreadSheet();
                HeaderRow row = sheet.getHeaderRow();
                for (i = 0; i < table.getColumnCount(); ++i) {
                    row.addCell("" + i).setContent(table.getColumnName(i));
                }
                for (int n = 0; n < table.getRowCount(); ++n) {
                    row = sheet.addRow("" + n);
                    for (i = 0; i < table.getColumnCount(); ++i) {
                        Object value = table.getValueAt(n, i);
                        if (value == null) continue;
                        row.addCell("" + i).setContent(value.toString());
                    }
                }
            }
        }
        if (sheet != null) {
            SpreadSheetFileChooser fileChooser = new SpreadSheetFileChooser();
            VFSJFileChooser.RETURN_TYPE retVal = fileChooser.showSaveDialog(null);
            if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
                result = "Export canceled by user!";
            }
            if (result == null) {
                try {
                    File file = fileChooser.getSelectedFile().getAbsoluteFile();
                    SpreadSheetWriter writer = fileChooser.getWriter();
                    if (!writer.write(sheet, file)) {
                        result = "Failed to export spreadsheet!";
                    }
                }
                catch (Exception e) {
                    String msg = "Failed to export spreadsheet: ";
                    result = msg + e;
                    this.getSystemErr().println(msg);
                    this.getSystemErr().printStackTrace((Throwable)e);
                }
            }
        } else {
            result = "Cannot export object as spreadsheet: " + o.getClass();
        }
        return result;
    }
}

