/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.SortSetupEvent;
import adams.gui.tools.spreadsheetviewer.SortPanel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SortDefinitionPanel
extends BasePanel {
    private static final long serialVersionUID = 8473224107052394069L;
    protected SortPanel m_Owner;
    protected JComboBox m_ComboBoxNames;
    protected JComboBox m_ComboBoxSorting;
    protected JButton m_ButtonRemove;

    public SortDefinitionPanel(SortPanel owner) {
        this.m_Owner = owner;
        this.update();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new FlowLayout(0));
        this.m_ComboBoxNames = new JComboBox();
        this.m_ComboBoxNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDefinitionPanel.this.setupModified();
            }
        });
        JLabel label = new JLabel("Names");
        label.setDisplayedMnemonic('N');
        label.setLabelFor(this.m_ComboBoxNames);
        this.add(label);
        this.add(this.m_ComboBoxNames);
        this.m_ComboBoxSorting = new JComboBox<String>(new String[]{"Ascending", "Descending"});
        this.m_ComboBoxSorting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDefinitionPanel.this.setupModified();
            }
        });
        label = new JLabel("Sorting");
        label.setDisplayedMnemonic('S');
        label.setLabelFor(this.m_ComboBoxNames);
        this.add(label);
        this.add(this.m_ComboBoxSorting);
        this.m_ButtonRemove = new JButton(GUIHelper.getIcon((String)"delete.gif"));
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDefinitionPanel.this.removeDefinition();
            }
        });
        this.add(this.m_ButtonRemove);
    }

    public SortPanel getOwner() {
        return this.m_Owner;
    }

    public String getColumnName() {
        if (this.m_ComboBoxNames.getSelectedIndex() == -1) {
            return null;
        }
        return (String)this.m_ComboBoxNames.getSelectedItem();
    }

    public boolean isAscending() {
        return this.m_ComboBoxSorting.getSelectedIndex() == 0;
    }

    protected void removeDefinition() {
        this.getOwner().removeDefinition(this);
    }

    public void update() {
        List<String> names = this.getOwner().getColumnNames();
        this.m_ComboBoxNames.setModel(new DefaultComboBoxModel<Object>(names.toArray()));
        if (names.size() > 0) {
            this.m_ComboBoxNames.setSelectedIndex(0);
        }
        this.m_ComboBoxSorting.setSelectedIndex(0);
    }

    protected void setupModified() {
        this.getOwner().notifySortSetupListeners(new SortSetupEvent(this.m_Owner, this, SortSetupEvent.EventType.MODIFIED));
    }

    public String toString() {
        return ((Object)((Object)this)).hashCode() + ", colname=" + this.getColumnName() + ", asc=" + this.isAscending();
    }
}

