/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.SortSetupEvent;
import adams.gui.event.SortSetupListener;
import adams.gui.tools.spreadsheetviewer.SortDefinitionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;

public class SortPanel
extends BasePanel {
    private static final long serialVersionUID = 7929780439384161250L;
    protected SpreadSheet m_Sheet;
    protected List<SortDefinitionPanel> m_Panels;
    protected GridLayout m_Layout;
    protected BasePanel m_PanelDefinitions;
    protected BasePanel m_PanelButtons;
    protected JButton m_ButtonNew;
    protected List<String> m_ColumnNames;
    protected HashSet<SortSetupListener> m_SortSetupListeners;

    protected void initialize() {
        super.initialize();
        this.m_Panels = new ArrayList<SortDefinitionPanel>();
        this.m_ColumnNames = new ArrayList<String>();
        this.m_SortSetupListeners = new HashSet();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Layout = new GridLayout(0, 1);
        this.m_PanelDefinitions = new BasePanel((LayoutManager)this.m_Layout);
        this.add((Component)this.m_PanelDefinitions, "Center");
        this.m_PanelButtons = new BasePanel((LayoutManager)new FlowLayout(2));
        this.add((Component)this.m_PanelButtons, "North");
        this.m_ButtonNew = new JButton(GUIHelper.getIcon((String)"new.gif"));
        this.m_ButtonNew.setToolTipText("Click to add a condition");
        this.m_ButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortPanel.this.addDefinition();
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonNew);
    }

    protected void finishInit() {
        super.finishInit();
        this.reset();
    }

    public void setSpreadSheet(SpreadSheet value) {
        this.m_Sheet = value;
        this.reset();
    }

    public SpreadSheet getSpreadSheet() {
        return this.m_Sheet;
    }

    public List<String> getColumnNames() {
        return this.m_ColumnNames;
    }

    public void addDefinition() {
        SortDefinitionPanel panel = new SortDefinitionPanel(this);
        this.m_Panels.add(panel);
        this.update();
        this.notifySortSetupListeners(new SortSetupEvent(this, panel, SortSetupEvent.EventType.ADD));
    }

    public void removeDefinition(SortDefinitionPanel panel) {
        if (this.m_Panels.remove((Object)panel)) {
            this.update();
            this.notifySortSetupListeners(new SortSetupEvent(this, panel, SortSetupEvent.EventType.REMOVE));
        }
    }

    public void reset() {
        this.m_Panels.clear();
        this.m_ColumnNames.clear();
        if (this.m_Sheet != null) {
            for (Cell cell : this.m_Sheet.getHeaderRow().cells()) {
                this.m_ColumnNames.add(cell.getContent());
            }
        }
        this.update();
        this.notifySortSetupListeners(new SortSetupEvent(this, null, SortSetupEvent.EventType.RESET));
    }

    protected void update() {
        this.m_PanelDefinitions.removeAll();
        this.m_Layout.setRows(this.m_Panels.size());
        for (SortDefinitionPanel panel : this.m_Panels) {
            this.m_PanelDefinitions.add((Component)((Object)panel));
        }
        this.revalidate();
        if (this.getParentDialog() != null) {
            this.getParentDialog().pack();
        }
    }

    public boolean isValidSetup() {
        HashSet<String> names = new HashSet<String>();
        for (SortDefinitionPanel panel : this.m_Panels) {
            if (names.contains(panel.getColumnName())) {
                return false;
            }
            names.add(panel.getColumnName());
        }
        return names.size() > 0;
    }

    public RowComparator getComparator() {
        if (!this.isValidSetup()) {
            return null;
        }
        int[] indices = new int[this.m_Panels.size()];
        boolean[] ascending = new boolean[this.m_Panels.size()];
        for (int i = 0; i < this.m_Panels.size(); ++i) {
            SortDefinitionPanel panel = this.m_Panels.get(i);
            indices[i] = this.m_ColumnNames.indexOf(panel.getColumnName());
            ascending[i] = panel.isAscending();
        }
        RowComparator result = new RowComparator(indices, ascending);
        return result;
    }

    public void addSortSetupListener(SortSetupListener l) {
        this.m_SortSetupListeners.add(l);
    }

    public void removeSortSetupListener(SortSetupListener l) {
        this.m_SortSetupListeners.remove(l);
    }

    public void notifySortSetupListeners(SortSetupEvent e) {
        for (SortSetupListener l : this.m_SortSetupListeners) {
            l.sortSetupChanged(e);
        }
    }
}

