/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.inspectionhandler;

import adams.core.ClassLocator;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.gui.visualization.debug.inspectionhandler.AbstractInspectionHandler;
import java.util.Hashtable;

public class SpreadSheet
extends AbstractInspectionHandler {
    public boolean handles(Class cls) {
        return ClassLocator.isSubclass(adams.data.spreadsheet.SpreadSheet.class, (Class)cls) || ClassLocator.hasInterface(Row.class, (Class)cls) || ClassLocator.isSubclass(Cell.class, (Class)cls);
    }

    public Hashtable<String, Object> inspect(Object obj) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        if (obj instanceof adams.data.spreadsheet.SpreadSheet) {
            adams.data.spreadsheet.SpreadSheet sheet = (adams.data.spreadsheet.SpreadSheet)obj;
            result.put("Sheet", sheet.toString());
        } else if (obj instanceof Row) {
            Row row = (Row)obj;
            result.put("Row", row.toString());
        } else if (obj instanceof Cell) {
            Cell cell = (Cell)obj;
            int index = cell.index();
            result.put("Name", cell.getSpreadSheet().getHeaderRow().getCell(index).getContent());
            result.put("Index", index);
            result.put("Type", cell.getContentType());
            result.put("Content", cell.getContent());
        }
        return result;
    }
}

