/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.CMapRangeMap;
import java.util.Iterator;

public class CMapBFRangeStringArrayMap
extends CMapRangeMap {
    private final char[][] destinations;
    private final COSArray strings;

    public CMapBFRangeStringArrayMap(byte[] start, byte[] end, COSArray strings) {
        super(start, end);
        this.strings = strings;
        this.destinations = new char[strings.size()][];
        int i = 0;
        Iterator it = strings.iterator();
        while (it.hasNext()) {
            COSString destination = ((COSObject)it.next()).asString();
            if (destination == null) {
                this.destinations[i] = new char[]{'?'};
            } else {
                byte[] destinationBytes = destination.byteValue();
                this.destinations[i] = new char[destinationBytes.length >> 1];
                int byteIndex = 0;
                int charIndex = 0;
                while (byteIndex < destinationBytes.length) {
                    this.destinations[i][charIndex++] = (char)((destinationBytes[byteIndex++] << 8) + destinationBytes[byteIndex++]);
                }
            }
            ++i;
        }
    }

    public char[] toChars(int codepoint) {
        int index = codepoint - this.start;
        if (index < 0 || index >= this.destinations.length) {
            return null;
        }
        return this.destinations[index];
    }

    public int toCID(int codepoint) {
        int index = codepoint - this.start;
        if (index < 0 || index >= this.strings.size()) {
            return 0;
        }
        return this.destinations[index][this.destinations[index].length - 1];
    }

    public int toCodepoint(int cid) {
        int i = 0;
        while (i < this.destinations.length) {
            if (cid == this.destinations[i][this.destinations[i].length - 1]) {
                return this.start + i;
            }
            ++i;
        }
        return 0;
    }
}

