/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font.outlet;

import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.font.outlet.NullFontFactory;
import java.util.Iterator;
import sun.misc.Service;

public class FontFactory {
    private static boolean lookupProviders = true;
    private static IFontFactory Unique;

    protected static IFontFactory findProviders() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = IFontFactory.class.getClassLoader();
        }
        Iterator ps = Service.providers(IFontFactory.class, (ClassLoader)loader);
        while (ps.hasNext()) {
            try {
                return (IFontFactory)ps.next();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static IFontFactory get() {
        if (Unique == null) {
            FontFactory.init();
        }
        return Unique;
    }

    protected static void init() {
        if (lookupProviders) {
            Unique = FontFactory.findProviders();
        }
        if (Unique == null) {
            Unique = new NullFontFactory();
        }
    }

    public static boolean isLookupProviders() {
        return lookupProviders;
    }

    public static void set(IFontFactory factory) {
        Unique = factory;
    }

    public static void setLookupProviders(boolean doLookupProviders) {
        lookupProviders = doLookupProviders;
    }
}

