/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseObject;

public class BaseBoolean
extends BaseObject {
    private static final long serialVersionUID = -3504062141216626521L;

    public BaseBoolean() {
        this("false");
    }

    public BaseBoolean(String s) {
        super(s);
    }

    public BaseBoolean(Boolean value) {
        this(value.toString());
    }

    protected String fixString(String s) {
        if ((s = s.toLowerCase()).equalsIgnoreCase("t")) {
            return "true";
        }
        if (s.equalsIgnoreCase("f")) {
            return "false";
        }
        return s;
    }

    @Override
    public boolean isValid(String value) {
        try {
            Boolean.parseBoolean(this.fixString(value));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        try {
            this.m_Internal = Boolean.valueOf(Boolean.parseBoolean(this.fixString(value)));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_Internal = new Boolean(false);
        }
    }

    @Override
    public String getValue() {
        return ((Boolean)this.m_Internal).toString();
    }

    public boolean booleanValue() {
        return (Boolean)this.m_Internal;
    }

    @Override
    public String getTipText() {
        return "A boolean value.";
    }
}

