/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractNumericOption;
import adams.core.option.AbstractRecursiveOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.FileBasedProducer;
import adams.core.option.OptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonProducer
extends AbstractRecursiveOptionProducer<JSONObject, Object>
implements FileBasedProducer {
    private static final long serialVersionUID = -7424639972010085977L;
    public static final String KEY_CLASS = "class";
    public static final String KEY_OPTIONS = "options";

    @Override
    public String globalInfo() {
        return "Generates JSON (JavaScript Object Notation) output.\n\nFor more information on JSON, see:\nhttp://json.org/";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_UsePropertyNames = true;
    }

    @Override
    protected JSONObject initOutput() {
        return new JSONObject();
    }

    protected void addArray(JSONObject obj, String key, Object[] values) {
        try {
            JSONArray array = new JSONArray();
            array.addAll(Arrays.asList(values));
            obj.put((Object)key, (Object)array);
        }
        catch (Exception e) {
            this.getSystemErr().println("Failed to add array as key '" + key + "':");
            this.getSystemErr().printStackTrace(e);
        }
    }

    protected void addArray(String key, Object[] values) {
        JSONArray array = new JSONArray();
        array.addAll(Arrays.asList(values));
        this.addPair(key, array);
    }

    protected void addArray(String key, Object values) {
        try {
            JSONArray array = new JSONArray();
            for (int i = 0; i < Array.getLength(values); ++i) {
                array.add(Array.get(values, i));
            }
            this.addPair(key, array);
        }
        catch (Exception e) {
            this.getSystemErr().println("Failed to add array for key '" + key + "':");
            this.getSystemErr().printStackTrace(e);
        }
    }

    protected void addPair(String key, Object value) {
        block4: {
            Object current = this.m_Nesting.empty() ? this.m_Output : this.m_Nesting.peek();
            try {
                if (current instanceof JSONObject) {
                    ((JSONObject)current).put((Object)key, value);
                    break block4;
                }
                if (current instanceof JSONArray) {
                    ((JSONArray)current).add(value);
                    break block4;
                }
                throw new IllegalStateException();
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to add value for key '" + key + "':");
                this.getSystemErr().printStackTrace(e);
            }
        }
    }

    protected JSONObject newObject(Object obj) {
        JSONObject result = new JSONObject();
        try {
            result.put((Object)KEY_CLASS, (Object)obj.getClass().getName());
        }
        catch (Exception e) {
            this.getSystemErr().println("Failed to add class name: " + obj.getClass().getName());
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    public Object processOption(BooleanOption option) {
        try {
            Object currValue = this.getCurrentValue(option);
            this.addPair(this.getOptionIdentifier(option), currValue);
        }
        catch (Exception e) {
            System.err.println("Error obtaining current value for '" + option.getProperty() + "':");
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Object processOption(ClassOption option) {
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            this.addPair(this.getOptionIdentifier(option), option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            Object currValues = null;
            if (currValue != null) {
                if (!option.isMultiple()) {
                    Object value = currValue;
                    JSONObject obj = this.newObject(currValue);
                    this.addPair(this.getOptionIdentifier(option), obj);
                    if (value instanceof OptionHandler) {
                        this.m_Nesting.push(obj);
                        this.doProduce(((OptionHandler)value).getOptionManager());
                        this.m_Nesting.pop();
                    } else {
                        AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
                        this.addArray(obj, KEY_OPTIONS, handler.getOptions(value));
                    }
                } else {
                    currValues = currValue;
                    JSONArray array = new JSONArray();
                    this.addPair(this.getOptionIdentifier(option), array);
                    this.m_Nesting.push(array);
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        Object value = Array.get(currValues, i);
                        JSONObject obj = this.newObject(value);
                        array.add((Object)obj);
                        if (value instanceof OptionHandler) {
                            this.m_Nesting.push(obj);
                            this.doProduce(((OptionHandler)value).getOptionManager());
                            this.m_Nesting.pop();
                            continue;
                        }
                        AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
                        this.addArray(obj, KEY_OPTIONS, handler.getOptions(value));
                    }
                    this.m_Nesting.pop();
                }
            }
        }
        return null;
    }

    @Override
    public Object processOption(AbstractArgumentOption option) {
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            this.addPair(this.getOptionIdentifier(option), option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            if (currValue != null) {
                if (!option.isMultiple()) {
                    if (!(option instanceof AbstractNumericOption)) {
                        currValue = option.toString(currValue);
                    }
                    this.addPair(this.getOptionIdentifier(option), currValue);
                } else {
                    this.addArray(this.getOptionIdentifier(option), currValue);
                }
            }
        }
        return null;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            ((JSONObject)this.m_Output).writeJSONString((Writer)writer);
        }
        catch (Exception e) {
            this.getSystemErr().println("Failed to generate string representation from JSON object:");
            this.getSystemErr().printStackTrace(e);
            writer = new StringWriter();
        }
        return writer.toString();
    }

    @Override
    protected void preProduce() {
        super.preProduce();
        this.m_Output = this.newObject(this.m_Input);
    }

    @Override
    public String getFileFormat() {
        return "JSON";
    }

    @Override
    public String getDefaultFileExtension() {
        return "json";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{this.getDefaultFileExtension()};
    }

    public static void main(String[] args) {
        JsonProducer.runProducer(JsonProducer.class, args);
    }
}

