/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.ArrayConsumer;
import adams.core.option.ArrayProducer;
import adams.core.option.CommandlineHelpProducer;
import adams.core.option.NestedConsumer;
import adams.core.option.NestedProducer;
import adams.core.option.OptionHandler;
import adams.db.DatabaseConnectionEstablisher;
import adams.db.DatabaseConnectionHandler;
import adams.env.Environment;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class OptionUtils {
    public static final String FILENAME = "Option.props";
    public static final String OPTION_PREFIX = "option.";
    protected static Hashtable<String, PropertyDescriptor> m_PropertyDescriptorCache = new Hashtable();
    protected static Hashtable<Class, Method> m_HooksValueOf = new Hashtable();
    protected static Hashtable<Class, Method> m_HooksToString = new Hashtable();
    protected static boolean m_HooksRegistered = false;
    protected static Properties m_Properties;
    protected static Boolean m_Debug;
    protected static Boolean m_SuppressDefaultValues;

    public static void addValueOfHook(Class key, Method method) {
        m_HooksValueOf.put(key, method);
    }

    public static void addValueOfHook(Class key, Class hookCls, String hookMethod) {
        try {
            OptionUtils.addValueOfHook(key, hookCls.getMethod(hookMethod, AbstractOption.class, String.class));
            Class<?> keyArray = Array.newInstance(key, 1).getClass();
            OptionUtils.addValueOfHook(keyArray, hookCls.getMethod(hookMethod, AbstractOption.class, String.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Method getValueOfHook(Class key) {
        return m_HooksValueOf.get(key);
    }

    public static void addToStringHook(Class key, Method method) {
        m_HooksToString.put(key, method);
    }

    public static void addToStringHook(Class key, Class hookCls, String hookMethod) {
        try {
            OptionUtils.addToStringHook(key, hookCls.getMethod(hookMethod, AbstractOption.class, Object.class));
            Class<?> keyArray = Array.newInstance(key, 1).getClass();
            OptionUtils.addToStringHook(keyArray, hookCls.getMethod(hookMethod, AbstractOption.class, Object.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Method getToStringHook(Class key) {
        return m_HooksToString.get(key);
    }

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("options");
        }
        return m_Properties;
    }

    public static synchronized boolean getSuppressDefaultValues() {
        if (m_SuppressDefaultValues == null) {
            m_SuppressDefaultValues = OptionUtils.getProperties().getBoolean("option.SuppressDefaultValues", true);
        }
        return m_SuppressDefaultValues;
    }

    public static synchronized boolean getDebug() {
        if (m_Debug == null) {
            m_Debug = OptionUtils.getProperties().getBoolean("option.Debug", false);
        }
        return m_Debug;
    }

    public static synchronized void registerCustomHooks() {
        if (m_HooksRegistered) {
            return;
        }
        m_HooksRegistered = true;
        Properties props = OptionUtils.getProperties();
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            Class<?> clsHook;
            boolean enabled;
            String classname = (String)enm.nextElement();
            if (classname.indexOf("#") > -1 || classname.startsWith(OPTION_PREFIX) || !(enabled = props.getBoolean(classname).booleanValue())) continue;
            Class<?> cls = null;
            try {
                cls = Class.forName(classname);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Cannot get class for '" + classname + "' - skipped!");
                continue;
            }
            String hookToString = props.getString(classname + "#toString");
            if (hookToString == null) {
                System.err.println("No 'toString' hook method for '" + classname + "' - skipped!");
                continue;
            }
            String hookValueOf = props.getString(classname + "#valueOf");
            if (hookValueOf == null) {
                System.err.println("No 'valueOf' hook method for '" + classname + "' - skipped!");
                continue;
            }
            try {
                clsHook = Class.forName(hookToString.replaceAll("#.*", ""));
                OptionUtils.addToStringHook(cls, clsHook, hookToString.replaceAll(".*#", ""));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error registering hook '" + hookToString + "'!");
                continue;
            }
            try {
                clsHook = Class.forName(hookValueOf.replaceAll("#.*", ""));
                OptionUtils.addValueOfHook(cls, clsHook, hookValueOf.replaceAll(".*#", ""));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error registering hook '" + hookValueOf + "'!");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String[] splitOptions(String quotedOptionString) throws Exception {
        result = new ArrayList<String>();
        str = new StringBuilder(quotedOptionString);
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = 0; i < str.length() && Character.isWhitespace(str.charAt(i)); ++i) {
            }
            if ((str = str.delete(0, i)).length() == 0) break;
            if (str.charAt(0) == '\"') {
                for (i = 1; i < str.length() && str.charAt(i) != str.charAt(0); ++i) {
                    if (str.charAt(i) != '\\' || ++i < str.length()) continue;
                    throw new Exception("String should not finish with \\");
                }
                if (i >= str.length()) {
                    throw new Exception("Quote parse error.");
                }
                optStr = str.substring(1, i);
                optStr = Utils.unbackQuoteChars(optStr);
                result.add(optStr);
                str = str.delete(0, i + 1);
                ** continue;
            }
            for (i = 0; i < str.length() && !Character.isWhitespace(str.charAt(i)); ++i) {
            }
            optStr = str.substring(0, i);
            result.add(optStr);
            str = str.delete(0, i);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String joinOptions(String[] optionArray) {
        StringBuilder optionString = new StringBuilder();
        for (int i = 0; i < optionArray.length; ++i) {
            boolean escape = false;
            if (optionArray[i] == null) continue;
            if (optionArray[i].equals("")) {
                escape = true;
            }
            for (int n = 0; n < optionArray[i].length(); ++n) {
                if (!Character.isWhitespace(optionArray[i].charAt(n))) continue;
                escape = true;
                break;
            }
            if (escape) {
                optionString.append('\"' + Utils.backQuoteChars(optionArray[i]) + '\"');
            } else {
                optionString.append(optionArray[i]);
            }
            optionString.append(" ");
        }
        return optionString.toString().trim();
    }

    public static String getCommandLine(Object obj) {
        AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(obj);
        String result = handler.toCommandLine(obj);
        result = result.trim();
        return result;
    }

    public static String getShortCommandLine(Object obj) {
        AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(obj);
        String result = handler.toShortCommandLine(obj);
        result = result.trim();
        return result;
    }

    public static String[] getOptions(Object obj) {
        return OptionUtils.getOptions(obj, false);
    }

    public static String[] getOptions(Object obj, boolean addClass) {
        AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(obj);
        String[] result = handler.getOptions(obj);
        if (addClass) {
            String[] newArray = new String[result.length + 1];
            System.arraycopy(result, 0, newArray, 1, result.length);
            newArray[0] = obj.getClass().getName();
            result = newArray;
        }
        return result;
    }

    public static Object forString(Class classType, String str) throws Exception {
        Object result;
        if (str.startsWith("#") || str.trim().indexOf(10) > -1) {
            NestedConsumer consumer = new NestedConsumer();
            consumer.setQuiet(true);
            result = consumer.fromString(str);
            consumer.cleanUp();
        } else {
            result = OptionUtils.forAnyCommandLine(classType, str);
        }
        return result;
    }

    public static Object forAnyCommandLine(Class classType, String cmdline) throws Exception {
        String[] options = OptionUtils.splitOptions(cmdline);
        String classname = options[0];
        options[0] = "";
        return OptionUtils.forName(classType, classname, options);
    }

    public static OptionHandler forCommandLine(Class classType, String cmdline) throws Exception {
        OptionHandler result = AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
        if (!classType.isAssignableFrom(result.getClass())) {
            throw new Exception(classType.getName() + " is not assignable from " + result.getClass());
        }
        return result;
    }

    public static Object forName(Class classType, String className, String[] options) throws Exception {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (Exception ex) {
            throw new Exception("Can't find class called: " + className);
        }
        if (!classType.isAssignableFrom(cls)) {
            throw new Exception(classType.getName() + " is not assignable from " + className);
        }
        Object result = cls.newInstance();
        if (options != null) {
            AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(result);
            handler.setOptions(result, options);
        }
        if (result instanceof DatabaseConnectionEstablisher) {
            ((DatabaseConnectionEstablisher)result).establishDatabaseConnection();
        }
        return result;
    }

    public static Object valueOf(Class cls, String value) throws Exception {
        PropertyEditor editor;
        Object result = null;
        if (cls == Byte.class || cls == Byte.TYPE) {
            result = Byte.valueOf(value);
        } else if (cls == Short.class || cls == Short.TYPE) {
            result = Short.valueOf(value);
        } else if (cls == Integer.class || cls == Integer.TYPE) {
            result = Integer.valueOf(value);
        } else if (cls == Long.class || cls == Long.TYPE) {
            result = Long.valueOf(value);
        } else if (cls == Float.class || cls == Float.TYPE) {
            result = Float.valueOf(value);
        } else if (cls == Double.class || cls == Double.TYPE) {
            result = Double.valueOf(value);
        } else if (cls == Boolean.class || cls == Boolean.TYPE) {
            result = Boolean.valueOf(value);
        } else if (cls == Character.class || cls == Character.TYPE) {
            result = "" + value;
        } else if (cls == String.class) {
            result = new String(value);
        }
        if (result == null && (editor = PropertyEditorManager.findEditor(cls)) instanceof CustomStringRepresentationHandler) {
            editor.setValue(cls.newInstance());
            result = ((CustomStringRepresentationHandler)((Object)editor)).fromCustomStringRepresentation(value);
        }
        if (result == null) {
            try {
                AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(cls);
                result = handler.fromCommandLine(value);
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            throw new IllegalStateException("Unhandled class: " + cls.getName());
        }
        return result;
    }

    public static OptionHandler shallowCopy(OptionHandler o, boolean expand) {
        OptionHandler result;
        try {
            NestedProducer producer = new NestedProducer();
            producer.setOutputVariableValues(expand);
            producer.produce(o);
            NestedConsumer consumer = new NestedConsumer();
            consumer.setInput(producer.getOutput());
            result = consumer.consume();
            producer.cleanUp();
            consumer.cleanUp();
            if (o instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)((Object)result)).setDatabaseConnection(((DatabaseConnectionHandler)((Object)o)).getDatabaseConnection());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static String checkRemainingOptions(String[] options) {
        String tmp;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() <= 0) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(options[i]);
        }
        if (result.length() > 0 && (tmp = result.toString().replace("\\", "").replace(" ", "")).length() == 0) {
            result = new StringBuilder();
        }
        if (result.length() == 0) {
            return null;
        }
        return "Unparsed options found:\n" + result.toString();
    }

    public static boolean helpRequested(String[] options) {
        return OptionUtils.helpRequested(new ArrayList<String>(Arrays.asList(options)));
    }

    public static boolean helpRequested(List<String> options) {
        return OptionUtils.hasFlag(options, "-h") || OptionUtils.hasFlag(options, "-help");
    }

    public static boolean hasFlag(String[] options, String flag) {
        return OptionUtils.hasFlag(new ArrayList<String>(Arrays.asList(options)), flag);
    }

    public static boolean hasFlag(List<String> options, String flag) {
        boolean result = false;
        for (int i = 0; i < options.size(); ++i) {
            if (!options.get(i).equals(flag)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean removeFlag(String[] options, String flag) {
        boolean result = false;
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals(flag)) continue;
            options[i] = "";
            result = true;
            break;
        }
        return result;
    }

    public static boolean removeFlag(List<String> options, String flag) {
        boolean result = false;
        for (int i = 0; i < options.size(); ++i) {
            if (!options.get(i).equals(flag)) continue;
            options.set(i, "");
            result = true;
            break;
        }
        return result;
    }

    public static String getOption(String[] options, String option) {
        return OptionUtils.getOption(new ArrayList<String>(Arrays.asList(options)), option);
    }

    public static String getOption(List<String> options, String option) {
        String result = null;
        for (int i = 0; i < options.size(); ++i) {
            if (!options.get(i).equals(option)) continue;
            if (i >= options.size() - 1) break;
            result = options.get(i + 1);
            break;
        }
        return result;
    }

    public static String removeOption(String[] options, String option) {
        String result = null;
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals(option)) continue;
            options[i] = "";
            if (i >= options.length - 1) break;
            result = options[i + 1];
            options[i + 1] = "";
            break;
        }
        return result;
    }

    public static String removeOption(List<String> options, String option) {
        String result = null;
        for (int i = 0; i < options.size(); ++i) {
            if (!options.get(i).equals(option)) continue;
            options.set(i, "");
            if (i >= options.size() - 1) break;
            result = options.get(i + 1);
            options.set(i + 1, "");
            break;
        }
        return result;
    }

    public static String list(OptionHandler handler) {
        return (String)AbstractOptionProducer.produce(CommandlineHelpProducer.class, handler);
    }

    public static boolean transferOptions(OptionHandler source, OptionHandler dest) {
        boolean result;
        try {
            String[] options = ArrayProducer.getOptions(source);
            ArrayConsumer.setOptions(dest, options);
            result = true;
        }
        catch (Exception e) {
            System.err.println("Failed to transfer options from '" + source + "' to '" + dest + "':");
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    protected static synchronized boolean hasPropertyDescriptor(Class cls, String property) {
        return m_PropertyDescriptorCache.containsKey(cls.getName() + "-" + property);
    }

    protected static synchronized PropertyDescriptor getPropertyDescriptor(Class cls, String property) {
        return m_PropertyDescriptorCache.get(cls.getName() + "-" + property);
    }

    protected static synchronized void addPropertyDescriptor(Class cls, String property, PropertyDescriptor descriptor) {
        m_PropertyDescriptorCache.put(cls.getName() + "-" + property, descriptor);
    }

    public static PropertyDescriptor getDescriptor(OptionHandler owner, String property) {
        PropertyDescriptor result;
        block10: {
            try {
                if (OptionUtils.hasPropertyDescriptor(owner.getClass(), property)) {
                    result = OptionUtils.getPropertyDescriptor(owner.getClass(), property);
                } else {
                    result = new PropertyDescriptor(property, owner.getClass());
                    OptionUtils.addPropertyDescriptor(owner.getClass(), property, result);
                }
            }
            catch (Exception e) {
                System.err.println("Error obtaining the property descriptor (" + owner.getClass().getName() + "):");
                e.printStackTrace();
                result = null;
                if (!OptionUtils.getDebug()) break block10;
                try {
                    int i;
                    BeanInfo info = Introspector.getBeanInfo(owner.getClass());
                    PropertyDescriptor[] propDescs = info.getPropertyDescriptors();
                    System.err.println("Available bean properties for class '" + owner.getClass().getName() + "':");
                    for (i = 0; i < propDescs.length; ++i) {
                        System.err.println(i + 1 + ". " + propDescs[i].getDisplayName());
                    }
                    MethodDescriptor[] methDescs = info.getMethodDescriptors();
                    System.err.println("Available bean methods for class '" + owner.getClass().getName() + "':");
                    for (i = 0; i < methDescs.length; ++i) {
                        System.err.println(i + 1 + ". " + methDescs[i].getDisplayName());
                        if (!methDescs[i].getDisplayName().equals("_getPyInstance")) continue;
                        Class<?> cls = methDescs[i].getMethod().getReturnType();
                        Method[] methods = cls.getMethods();
                        for (int n = 0; n < methods.length; ++n) {
                            System.err.println("    " + (n + 1) + ". " + methods[n].getName());
                        }
                    }
                    Method[] meths = owner.getClass().getMethods();
                    System.err.println("Available methods for class '" + owner.getClass().getName() + "':");
                    for (i = 0; i < meths.length; ++i) {
                        System.err.println(i + 1 + ". " + meths[i].getName());
                    }
                }
                catch (Exception ex) {
                    System.err.println("Failed to obtain bean info/property descriptors for class '" + owner.getClass().getName() + "'");
                }
            }
        }
        return result;
    }
}

