/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.AdditionalInformationHandler;
import adams.core.ClassLocator;
import adams.core.Utils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractDocumentationProducer;
import adams.core.option.AbstractOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.FileBasedProducer;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.core.option.RecursiveOptionProducer;
import adams.doc.xhtml.Anchor;
import adams.doc.xhtml.Body;
import adams.doc.xhtml.Code;
import adams.doc.xhtml.Document;
import adams.doc.xhtml.Heading;
import adams.doc.xhtml.ListItem;
import adams.doc.xhtml.OrderedList;
import adams.doc.xhtml.Paragraph;
import adams.doc.xhtml.Pre;
import adams.doc.xhtml.Table;
import adams.doc.xhtml.Title;
import adams.doc.xhtml.UnorderedList;
import adams.doc.xml.AbstractTag;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.gui.core.BaseTreeNode;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;

public class XhtmlProducer
extends AbstractDocumentationProducer<String>
implements RecursiveOptionProducer,
FileBasedProducer {
    private static final long serialVersionUID = -1354998807180416601L;
    protected Document m_Document;
    protected boolean m_OutputDefaultValues;

    @Override
    public String globalInfo() {
        return "Generates comprehensive output in DocBook format, including the descriptions for the options and (optionally) the default values.\n\nFor more information on the DocBook XML format, see:\nhttp://www.docbook.org/";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-default-values", "outputDefaultValues", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Document = new Document();
    }

    @Override
    protected String initOutput() {
        return "";
    }

    public void setOutputDefaultValues(boolean value) {
        this.m_OutputDefaultValues = value;
        this.reset();
    }

    public boolean getOutputDefaultValues() {
        return this.m_OutputDefaultValues;
    }

    public String outputDefaultValuesTipText() {
        return "Whether to output or suppress default values.";
    }

    protected String toPlainText(Tree tree) {
        StringBuilder result = new StringBuilder();
        Object root = tree.getModel().getRoot();
        if (root instanceof BaseTreeNode) {
            ArrayList<Boolean> more = new ArrayList<Boolean>();
            more.add(false);
            this.toPlainText(result, 0, (BaseTreeNode)root, more);
        } else {
            result.append("Cannot generate tree!");
        }
        return result.toString();
    }

    protected String toPlainText(Node node) {
        StringBuilder result = new StringBuilder();
        AbstractActor actor = node.getActor();
        if (actor == null) {
            result.append("[none]");
        } else {
            result.append(AbstractTag.toEntities(actor.getName()));
            if (actor.getSkip()) {
                result.insert(0, "---");
                result.append("---");
            }
        }
        if (this.m_NamePosition.containsKey(actor.getFullName())) {
            AbstractDocumentationProducer.ActorPosition pos = (AbstractDocumentationProducer.ActorPosition)this.m_NamePosition.get(actor.getFullName());
            result.append(" <a href=\"#" + pos.index + "\">[" + pos.index + "]</a>");
        }
        return result.toString();
    }

    protected void toPlainText(StringBuilder builder, int level, BaseTreeNode node, List<Boolean> more) {
        int i;
        StringBuilder indentStr = new StringBuilder();
        for (i = 0; i < level; ++i) {
            if (more.get(i).booleanValue()) {
                indentStr.append("| ");
                continue;
            }
            indentStr.append("  ");
        }
        if (level > 0) {
            builder.append((CharSequence)indentStr);
            builder.append("|\n");
        }
        String[] lines = this.toPlainText((Node)node).split("\n");
        for (i = 0; i < lines.length; ++i) {
            builder.append((CharSequence)indentStr);
            if (i == 0) {
                builder.append("+ ");
            } else {
                builder.append("  ");
            }
            builder.append(lines[i] + "\n");
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            more.add(i < node.getChildCount() - 1);
            this.toPlainText(builder, level + 1, (BaseTreeNode)child, more);
            more.remove(more.size() - 1);
        }
    }

    protected void addSynopsis(AbstractTag parent, Object obj) {
        String addInfo;
        Table table = new Table(2);
        table.setAttribute("border", "1");
        table.setAttribute("cellspacing", "0");
        parent.add(table);
        try {
            Method method = obj.getClass().getMethod("globalInfo", new Class[0]);
            if (method != null) {
                String globalInfo = (String)method.invoke(obj, new Object[0]);
                table.addRow(new String[]{"Synopsis", globalInfo});
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (obj instanceof AdditionalInformationHandler && (addInfo = ((AdditionalInformationHandler)((Object)this.getInput())).getAdditionalInformation()) != null && addInfo.length() > 0) {
            table.addRow(new AbstractTag[]{new Paragraph("Additional information"), new Pre(addInfo)});
        }
    }

    @Override
    protected void preProduce() {
        super.preProduce();
        this.m_Output = null;
        this.m_Document = new Document();
        this.m_Document.getRoot().getHead().add(new Title("Setup documentation"));
    }

    protected void generateDocument() {
        Paragraph para;
        AbstractActor actor = null;
        if (this.m_Input instanceof AbstractActor) {
            // empty if block
        }
        actor = (AbstractActor)this.m_Input;
        Body body = this.m_Document.getRoot().getBody();
        Heading heading = new Heading(1, "Structure");
        body.add(heading);
        if (actor != null) {
            para = new Paragraph();
            body.add(para);
            para.setContent(actor.getName());
            if (!actor.getAnnotations().isEmpty()) {
                para = new Paragraph();
                body.add(para);
                para.setContent(actor.getAnnotations().getValue());
            }
        }
        Tree tree = new Tree(null, (AbstractActor)this.getInput());
        Code listing = new Code();
        Object[] lines = Utils.split(this.toPlainText(tree), "\n");
        listing.setContent(Utils.flatten(lines, "<br/>\n"));
        listing.setConvertEntities(false);
        body.add(listing);
        heading = new Heading(1, "Details");
        body.add(heading);
        OrderedList olist = new OrderedList();
        body.add(olist);
        for (AbstractDocumentationProducer.ActorPosition item : this.m_Positions) {
            ListItem listitem = new ListItem();
            olist.add(listitem);
            para = new Paragraph();
            para.add(new Anchor("" + item.index, null, item.actor.getName()));
            listitem.add(para);
            this.addSynopsis(listitem, item.actor);
            UnorderedList ulist = new UnorderedList();
            ActorOptionTraverser traverser = new ActorOptionTraverser(ulist, this.m_OutputVariableValues, this.m_OutputDefaultValues);
            item.actor.getOptionManager().traverse(traverser);
            if (ulist.getChildCount() <= 0) continue;
            para = new Paragraph();
            para.setContent("Option" + (ulist.getChildCount() > 0 ? "s" : "") + ":");
            listitem.add(para);
            listitem.add(ulist);
        }
    }

    @Override
    public String getOutput() {
        if (this.m_Output == null) {
            this.generateDocument();
            StringBuilder buffer = new StringBuilder();
            this.m_Document.toXML(buffer);
            this.m_Output = buffer.toString();
        }
        return (String)this.m_Output;
    }

    @Override
    public String toString() {
        return this.getOutput();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Document = null;
    }

    @Override
    public String getFileFormat() {
        return "XHTML";
    }

    @Override
    public String getDefaultFileExtension() {
        return "html";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{this.getDefaultFileExtension()};
    }

    public static void main(String[] args) {
        XhtmlProducer.runProducer(XhtmlProducer.class, args);
    }

    public static class ActorOptionTraverser
    implements OptionTraverser {
        protected UnorderedList m_Details;
        protected boolean m_OutputVariableValues;
        protected boolean m_OutputDefaultValues;

        public ActorOptionTraverser(UnorderedList details, boolean varValues, boolean defValues) {
            this.m_Details = details;
            this.m_OutputVariableValues = varValues;
            this.m_OutputDefaultValues = defValues;
        }

        protected void addDescription(Table parent, AbstractOption option) {
            String description;
            try {
                Method method = option.getToolTipMethod();
                description = (String)method.invoke((Object)option.getOptionHandler(), new Object[0]);
            }
            catch (Exception e) {
                description = "-none-";
            }
            parent.addRow(new String[]{"Description", description});
        }

        protected Table addStaticInfo(AbstractOption option) {
            ListItem listitem = new ListItem();
            this.m_Details.add(listitem);
            Paragraph para = new Paragraph();
            para.setContent(option.getProperty() + "/" + "-" + option.getCommandline());
            listitem.add(para);
            Table table = new Table(2);
            table.setAttribute("border", "1");
            table.setAttribute("cellspacing", "0");
            listitem.add(table);
            this.addDescription(table, option);
            return table;
        }

        @Override
        public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            boolean different = ((Boolean)option.getCurrentValue()).equals((Boolean)option.getDefaultValue());
            if (this.m_OutputDefaultValues || different) {
                Table table = this.addStaticInfo(option);
                table.addRow(new String[]{"value", "" + option.getCurrentValue()});
            }
        }

        @Override
        public void handleClassOption(ClassOption option, OptionTraversalPath path) {
            this.handleArgumentOption(option, path);
        }

        @Override
        public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
            if (option.isVariableAttached() && !this.m_OutputVariableValues) {
                Table table = this.addStaticInfo(option);
                table.addRow(new String[]{"variable", option.getVariable()});
            } else {
                Object currValue = option.getCurrentValue();
                if ((this.m_OutputDefaultValues || !option.isDefaultValue(currValue)) && currValue != null) {
                    Table table = this.addStaticInfo(option);
                    if (!option.isMultiple()) {
                        table.addRow(new String[]{"value", option.toString(currValue)});
                    } else {
                        for (int i = 0; i < Array.getLength(currValue); ++i) {
                            table.addRow(new String[]{"value[" + i + "]", option.toString(Array.get(currValue, i))});
                        }
                    }
                }
            }
        }

        @Override
        public boolean canHandle(AbstractOption option) {
            if (option instanceof AbstractArgumentOption) {
                AbstractArgumentOption opt = (AbstractArgumentOption)option;
                return opt.getBaseClass() != Actor.class && opt.getBaseClass() != AbstractActor.class;
            }
            return false;
        }

        @Override
        public boolean canRecurse(Class cls) {
            return !ClassLocator.hasInterface(Actor.class, cls) && !ClassLocator.isSubclass(AbstractActor.class, cls);
        }

        @Override
        public boolean canRecurse(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.canRecurse(obj.getClass());
        }
    }
}

