/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.CleanUpHandler;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.data.conversion.Conversion;
import adams.data.conversion.ConversionWithInitialization;
import adams.data.conversion.StreamConversion;

public abstract class AbstractConversion
extends AbstractOptionHandler
implements Conversion,
CleanUpHandler,
ShallowCopySupporter<AbstractConversion> {
    private static final long serialVersionUID = 1576117521811422376L;
    protected Object m_Owner;
    protected Object m_Input;
    protected Object m_Output;
    protected boolean m_Stopped;

    @Override
    protected void reset() {
        super.reset();
        this.m_Output = null;
    }

    @Override
    public void setOwner(Object value) {
        this.m_Owner = value;
        this.reset();
    }

    @Override
    public Object getOwner() {
        return this.m_Owner;
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public abstract Class accepts();

    @Override
    public void setInput(Object value) {
        this.m_Input = value;
        if (this instanceof StreamConversion) {
            this.m_Output = null;
        } else {
            this.reset();
        }
    }

    @Override
    public Object getInput() {
        return this.m_Input;
    }

    @Override
    public abstract Class generates();

    @Override
    public Object getOutput() {
        return this.m_Output;
    }

    protected String checkData() {
        if (this.m_Input == null) {
            return "No input data available!";
        }
        if (!this.accepts().isAssignableFrom(this.m_Input.getClass())) {
            return "Data cannot be processed: input=" + this.m_Input.getClass().getName() + ", accepts=" + this.accepts().getName();
        }
        return null;
    }

    protected abstract Object doConvert() throws Exception;

    @Override
    public String convert() {
        this.m_Stopped = false;
        if (this.isDebugOn()) {
            this.debug("Input: " + this.m_Input);
        }
        this.m_Output = null;
        String result = this.checkData();
        if (this.isDebugOn()) {
            this.debug("Check: " + result);
        }
        if (result == null && this instanceof ConversionWithInitialization && ((ConversionWithInitialization)((Object)this)).requiresSetUp()) {
            result = ((ConversionWithInitialization)((Object)this)).setUp();
            if (this.isDebugOn()) {
                this.debug("SetUp: " + result);
            }
        }
        if (result == null) {
            try {
                this.m_Output = this.doConvert();
                if (this.isDebugOn()) {
                    this.debug("Output: " + this.m_Output);
                }
            }
            catch (Exception e) {
                String msg = "Failed to convert data (" + this.accepts().getName() + " -> " + this.generates().getName() + "):";
                result = msg + " " + e;
                this.getSystemErr().println(msg);
                this.getSystemErr().printStackTrace(e);
            }
        }
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_Input = null;
        this.m_Output = null;
    }

    @Override
    public AbstractConversion shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractConversion shallowCopy(boolean expand) {
        return (AbstractConversion)OptionUtils.shallowCopy(this, expand);
    }

    @Override
    public void stopExecution() {
        this.m_Stopped = true;
    }
}

