/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;

public class ArrayToCollection
extends AbstractConversion {
    private static final long serialVersionUID = 1028362547528503041L;
    protected String m_CollectionClass;

    @Override
    public String globalInfo() {
        return "Turns an array into a collection.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("collection-class", "collectionClass", ArrayList.class.getName());
    }

    public void setCollectionClass(String value) {
        if (value.length() > 0) {
            this.m_CollectionClass = value;
            this.reset();
        } else {
            this.getSystemErr().println("Class cannot be empty!");
        }
    }

    public String getCollectionClass() {
        return this.m_CollectionClass;
    }

    public String collectionClassTipText() {
        return "The class to use for the collection.";
    }

    @Override
    public Class accepts() {
        return Object[].class;
    }

    @Override
    public Class generates() {
        return Collection.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        Collection result = (Collection)Class.forName(this.m_CollectionClass).newInstance();
        int len = Array.getLength(this.m_Input);
        for (int i = 0; i < len; ++i) {
            result.add(Array.get(this.m_Input, i));
        }
        return result;
    }
}

