/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import java.lang.reflect.Array;
import java.util.Collection;

public class CollectionToArray
extends AbstractConversion {
    private static final long serialVersionUID = 1028362547528503041L;
    protected String m_ArrayClass;

    @Override
    public String globalInfo() {
        return "Turns a collection into an array.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("array-class", "arrayClass", Object.class.getName());
    }

    public void setArrayClass(String value) {
        if (value.length() > 0) {
            this.m_ArrayClass = value;
            this.reset();
        } else {
            this.getSystemErr().println("Class cannot be empty!");
        }
    }

    public String getArrayClass() {
        return this.m_ArrayClass;
    }

    public String arrayClassTipText() {
        return "The class to use for the elements in the array.";
    }

    @Override
    public Class accepts() {
        return Collection.class;
    }

    @Override
    public Class generates() {
        try {
            return Array.newInstance(Class.forName(this.m_ArrayClass), 0).getClass();
        }
        catch (Exception e) {
            return Object[].class;
        }
    }

    @Override
    protected Object doConvert() throws Exception {
        Collection coll = (Collection)this.m_Input;
        Object result = Array.newInstance(Class.forName(this.m_ArrayClass), coll.size());
        int i = 0;
        for (Object item : coll) {
            Array.set(result, i, item);
            ++i;
        }
        return result;
    }
}

