/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.ClassLister;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionHandler;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.DataRowType;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.input.ReaderInputStream;

public abstract class AbstractSpreadSheetReader
extends AbstractOptionHandler
implements SpreadSheetReader {
    private static final long serialVersionUID = 4828477005893179066L;
    protected DataRowType m_DataRowType;
    protected boolean m_Stopped;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)this.getDefaultDataRowType());
    }

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    protected DataRowType getDefaultDataRowType() {
        return DataRowType.DENSE;
    }

    @Override
    public void setDataRowType(DataRowType value) {
        this.m_DataRowType = value;
        this.reset();
    }

    @Override
    public DataRowType getDataRowType() {
        return this.m_DataRowType;
    }

    @Override
    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    protected abstract InputType getInputType();

    protected void check() {
    }

    @Override
    public SpreadSheet read(File file) {
        return this.read(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public SpreadSheet read(String filename) {
        this.check();
        this.m_Stopped = false;
        reader = null;
        input = null;
        try {
            switch (1.$SwitchMap$adams$data$io$input$AbstractSpreadSheetReader$InputType[this.getInputType().ordinal()]) {
                case 1: {
                    result = this.doRead(new PlaceholderFile(filename));
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 2: {
                    input = new FileInputStream(filename);
                    result = this.doRead(input);
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                case 3: {
                    reader = new BufferedReader(new FileReader(filename));
                    result = this.doRead(reader);
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled input type: " + (Object)this.getInputType());
                }
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        finally {
            if (!(this instanceof ChunkedSpreadSheetReader)) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        if (this.m_Stopped) {
            result = null;
        }
        return result;
    }

    @Override
    public SpreadSheet read(InputStream stream) {
        SpreadSheet result;
        this.check();
        this.m_Stopped = false;
        try {
            switch (this.getInputType()) {
                case FILE: {
                    throw new IllegalStateException("Only supports reading from files, not input streams!");
                }
                case STREAM: {
                    result = this.doRead(stream);
                    break;
                }
                case READER: {
                    result = this.doRead(new BufferedReader(new InputStreamReader(stream)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled input type: " + (Object)((Object)this.getInputType()));
                }
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        if (this.m_Stopped) {
            result = null;
        }
        return result;
    }

    @Override
    public SpreadSheet read(Reader r) {
        SpreadSheet result;
        this.check();
        this.m_Stopped = false;
        try {
            switch (this.getInputType()) {
                case FILE: {
                    throw new IllegalStateException("Only supports reading from files, not input streams!");
                }
                case STREAM: {
                    result = this.doRead((InputStream)new ReaderInputStream(r));
                    break;
                }
                case READER: {
                    result = this.doRead(r);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled input type: " + (Object)((Object)this.getInputType()));
                }
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        if (this.m_Stopped) {
            result = null;
        }
        return result;
    }

    protected SpreadSheet doRead(File file) {
        return null;
    }

    protected SpreadSheet doRead(Reader r) {
        return null;
    }

    protected SpreadSheet doRead(InputStream in) {
        return null;
    }

    @Override
    public void stopExecution() {
        this.m_Stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.m_Stopped;
    }

    public static String[] getReaders() {
        return ClassLister.getSingleton().getClassnames(SpreadSheetReader.class);
    }

    public static enum InputType {
        FILE,
        READER,
        STREAM;

    }
}

