/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateFormat;
import adams.core.DateTime;
import adams.core.Range;
import adams.core.Time;
import adams.core.Utils;
import adams.core.management.LocaleHelper;
import adams.core.management.OptionHandlingLocaleSupporter;
import adams.data.DateFormatString;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class CsvSpreadSheetReader
extends AbstractSpreadSheetReaderWithMissingValueSupport
implements ChunkedSpreadSheetReader,
OptionHandlingLocaleSupporter {
    private static final long serialVersionUID = 4461796269354230002L;
    protected String m_Separator;
    protected Range m_TextColumns;
    protected Range m_DateColumns;
    protected DateFormatString m_DateFormat;
    protected boolean m_DateLenient;
    protected Range m_DateTimeColumns;
    protected DateFormatString m_DateTimeFormat;
    protected boolean m_DateTimeLenient;
    protected Range m_TimeColumns;
    protected DateFormatString m_TimeFormat;
    protected boolean m_TimeLenient;
    protected TimeZone m_TimeZone;
    protected Locale m_Locale;
    protected boolean m_NoHeader;
    protected String m_CustomColumnHeaders;
    protected int m_ChunkSize;
    protected ChunkReader m_Reader;

    @Override
    public String globalInfo() {
        return "Reads CSV files.\nIt is possible to force columns to be text. In that case no intelligent parsing is attempted to determine the type of data a cell has.\nFor very large files, one can turn on chunking, which returns spreadsheet objects till all the data has been read.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("separator", "separator", ",");
        this.m_OptionManager.add("text-columns", "textColumns", new Range());
        this.m_OptionManager.add("date-columns", "dateColumns", new Range());
        this.m_OptionManager.add("date-format", "dateFormat", new DateFormatString("yyyy-MM-dd"));
        this.m_OptionManager.add("date-lenient", "dateLenient", false);
        this.m_OptionManager.add("datetime-columns", "dateTimeColumns", new Range());
        this.m_OptionManager.add("datetime-format", "dateTimeFormat", new DateFormatString("yyyy-MM-dd HH:mm:ss"));
        this.m_OptionManager.add("datetime-lenient", "dateTimeLenient", false);
        this.m_OptionManager.add("time-columns", "timeColumns", new Range());
        this.m_OptionManager.add("time-format", "timeFormat", new DateFormatString("HH:mm:ss"));
        this.m_OptionManager.add("time-lenient", "timeLenient", false);
        this.m_OptionManager.add("time-zone", "timeZone", TimeZone.getDefault(), false);
        this.m_OptionManager.add("locale", "locale", LocaleHelper.getSingleton().getDefault());
        this.m_OptionManager.add("no-header", "noHeader", false);
        this.m_OptionManager.add("custom-column-headers", "customColumnHeaders", "");
        this.m_OptionManager.add("chunk-size", "chunkSize", -1, -1, null);
    }

    public void setSeparator(String value) {
        if (Utils.unbackQuoteChars(value).length() == 1) {
            this.m_Separator = Utils.unbackQuoteChars(value);
            this.reset();
        } else {
            this.getSystemErr().println("Only one character allowed (or two, in case of backquoted ones), provided: " + value);
        }
    }

    public String getSeparator() {
        return Utils.backQuoteChars(this.m_Separator);
    }

    public String separatorTipText() {
        return "The separator to use for the columns; use '\\t' for tab.";
    }

    public void setTextColumns(Range value) {
        this.m_TextColumns = value;
        this.reset();
    }

    public Range getTextColumns() {
        return this.m_TextColumns;
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text; " + this.m_TextColumns.getExample();
    }

    public void setDateColumns(Range value) {
        this.m_DateColumns = value;
        this.reset();
    }

    public Range getDateColumns() {
        return this.m_DateColumns;
    }

    public String dateColumnsTipText() {
        return "The range of columns to treat as date; " + this.m_DateColumns.getExample();
    }

    public void setDateFormat(DateFormatString value) {
        this.m_DateFormat = value;
        this.reset();
    }

    public DateFormatString getDateFormat() {
        return this.m_DateFormat;
    }

    public String dateFormatTipText() {
        return "The format for dates.";
    }

    public void setDateLenient(boolean value) {
        this.m_DateLenient = value;
        this.reset();
    }

    public boolean isDateLenient() {
        return this.m_DateLenient;
    }

    public String dateLenientTipText() {
        return "Whether date parsing is lenient or not.";
    }

    public void setDateTimeColumns(Range value) {
        this.m_DateTimeColumns = value;
        this.reset();
    }

    public Range getDateTimeColumns() {
        return this.m_DateTimeColumns;
    }

    public String dateTimeColumnsTipText() {
        return "The range of columns to treat as date/time; " + this.m_DateTimeColumns.getExample();
    }

    public void setDateTimeFormat(DateFormatString value) {
        this.m_DateTimeFormat = value;
        this.reset();
    }

    public DateFormatString getDateTimeFormat() {
        return this.m_DateTimeFormat;
    }

    public String dateTimeFormatTipText() {
        return "The format for date/times.";
    }

    public void setDateTimeLenient(boolean value) {
        this.m_DateTimeLenient = value;
        this.reset();
    }

    public boolean isDateTimeLenient() {
        return this.m_DateTimeLenient;
    }

    public String dateTimeLenientTipText() {
        return "Whether date/time parsing is lenient or not.";
    }

    public void setTimeColumns(Range value) {
        this.m_TimeColumns = value;
        this.reset();
    }

    public Range getTimeColumns() {
        return this.m_TimeColumns;
    }

    public String timeColumnsTipText() {
        return "The range of columns to treat as time; " + this.m_TimeColumns.getExample();
    }

    public void setTimeFormat(DateFormatString value) {
        this.m_TimeFormat = value;
        this.reset();
    }

    public DateFormatString getTimeFormat() {
        return this.m_TimeFormat;
    }

    public String timeFormatTipText() {
        return "The format for times.";
    }

    public void setTimeLenient(boolean value) {
        this.m_TimeLenient = value;
        this.reset();
    }

    public boolean isTimeLenient() {
        return this.m_TimeLenient;
    }

    public String timeLenientTipText() {
        return "Whether time parsing is lenient or not.";
    }

    public void setTimeZone(TimeZone value) {
        this.m_TimeZone = value;
        this.reset();
    }

    public TimeZone getTimeZone() {
        return this.m_TimeZone;
    }

    public String timeZoneTipText() {
        return "The time zone to use for interpreting dates/times; default is the system-wide defined one.";
    }

    @Override
    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    @Override
    public Locale getLocale() {
        return this.m_Locale;
    }

    @Override
    public String localeTipText() {
        return "The locale to use for parsing the numbers.";
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
        this.reset();
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, all rows get added as data rows and a dummy header will get inserted.";
    }

    public void setCustomColumnHeaders(String value) {
        this.m_CustomColumnHeaders = value;
        this.reset();
    }

    public String getCustomColumnHeaders() {
        return this.m_CustomColumnHeaders;
    }

    public String customColumnHeadersTipText() {
        return "The custom headers to use for the columns instead (comma-separated list); ignored if empty.";
    }

    @Override
    public void setChunkSize(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ChunkSize = value;
        this.reset();
    }

    @Override
    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    @Override
    public String chunkSizeTipText() {
        return "The maximum number of rows per chunk; using -1 will read put all data into a single spreadsheet object.";
    }

    @Override
    public String getFormatDescription() {
        return "Comma-separated values files";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"csv"};
    }

    @Override
    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.READER;
    }

    @Override
    protected SpreadSheet doRead(Reader r) {
        this.m_Reader = new ChunkReader(this);
        return this.m_Reader.read(r, this.m_ChunkSize);
    }

    @Override
    public boolean hasMoreChunks() {
        return this.m_Reader != null && this.m_Reader.hasNext();
    }

    @Override
    public SpreadSheet nextChunk() {
        if (this.m_Reader == null || !this.m_Reader.hasNext()) {
            return null;
        }
        return this.m_Reader.next();
    }

    public static class ChunkReader
    implements Serializable {
        private static final long serialVersionUID = 26915431591885853L;
        protected CsvSpreadSheetReader m_Owner;
        protected BufferedReader m_Reader;
        protected SpreadSheet m_Header;
        protected boolean m_HasTextCols;
        protected boolean m_HasDateCols;
        protected boolean m_HasDateTimeCols;
        protected boolean m_HasTimeCols;
        protected DateFormat m_DateFormat;
        protected DateFormat m_DateTimeFormat;
        protected DateFormat m_TimeFormat;
        protected NumberFormat m_NumberFormat;
        protected int m_ChunkSize;
        protected char m_Separator;
        protected List<String> m_HeaderCells;

        public ChunkReader(CsvSpreadSheetReader owner) {
            this.m_Owner = owner;
        }

        protected String unquote(String s) {
            String result = Utils.unquote(s);
            result = Utils.unDoubleQuote(result);
            result = Utils.unbackQuoteChars(result, new String[]{"\"\""}, new char[]{'\"'});
            return result;
        }

        protected void removeTrailingCR(StringBuilder current) {
            if (current.length() > 0 && current.charAt(current.length() - 1) == '\r') {
                current.delete(current.length() - 1, current.length());
            }
        }

        protected List<String> readCells(Reader reader) throws IOException {
            int in;
            ArrayList<String> result = new ArrayList<String>();
            StringBuilder current = new StringBuilder();
            boolean escaped = false;
            char escapeChr = '\u0000';
            boolean lineFinished = false;
            boolean firstChr = true;
            while (!lineFinished && (in = reader.read()) != -1) {
                firstChr = false;
                char chr = (char)in;
                if (chr == this.m_Separator) {
                    if (escaped) {
                        current.append(chr);
                        continue;
                    }
                    this.removeTrailingCR(current);
                    result.add(this.unquote(current.toString()));
                    if (current.length() > 0) {
                        current.delete(0, current.length());
                    }
                    escapeChr = '\u0000';
                    continue;
                }
                if (chr == '\'' || chr == '\"') {
                    if (chr == escapeChr) {
                        escaped = !escaped;
                    } else if (escapeChr == '\u0000') {
                        escaped = true;
                        escapeChr = chr;
                    }
                    current.append(chr);
                    continue;
                }
                if (chr == '\n') {
                    if (escaped) {
                        this.removeTrailingCR(current);
                        current.append(chr);
                        continue;
                    }
                    lineFinished = true;
                    continue;
                }
                current.append(chr);
            }
            if (!firstChr) {
                this.removeTrailingCR(current);
                result.add(this.unquote(current.toString()));
            } else {
                result = null;
            }
            return result;
        }

        public SpreadSheet next() {
            SpreadSheet result;
            if (this.m_Header == null) {
                result = new SpreadSheet();
                result.setDateLenient(this.m_Owner.isDateLenient());
                result.setDateTimeLenient(this.m_Owner.isDateTimeLenient());
                result.setTimeLenient(this.m_Owner.isTimeLenient());
                result.setTimeZone(this.m_Owner.getTimeZone());
                result.setLocale(this.m_Owner.getLocale());
                result.setDataRowClass(this.m_Owner.getDataRowType().getRowClass());
            } else {
                result = this.m_Header.getHeader();
            }
            try {
                boolean comments;
                boolean bl = comments = this.m_Header == null;
                while (!this.m_Owner.isStopped()) {
                    List<String> cells = this.readCells(this.m_Reader);
                    if (cells == null) {
                        this.m_Reader.close();
                        this.m_Reader = null;
                    } else {
                        int i;
                        Row row;
                        boolean isHeader;
                        if (comments && cells.get(0).startsWith("#")) {
                            result.addComment(Utils.flatten(cells, ",").substring(1).trim());
                            continue;
                        }
                        comments = false;
                        if (cells.size() == 1 && cells.get(0).trim().length() == 0) continue;
                        if (this.m_HeaderCells == null) {
                            isHeader = true;
                            if (this.m_Owner.getCustomColumnHeaders().trim().length() > 0) {
                                this.m_HeaderCells = new ArrayList<String>(Arrays.asList(this.m_Owner.getCustomColumnHeaders().trim().split(",")));
                                row = result.getHeaderRow();
                                for (i = 0; i < this.m_HeaderCells.size(); ++i) {
                                    row.addCell("" + i).setContent(this.m_HeaderCells.get(i));
                                }
                                row = result.addRow();
                            } else if (this.m_Owner.getNoHeader()) {
                                if (this.m_Owner.getCustomColumnHeaders().trim().length() > 0) {
                                    this.m_HeaderCells = new ArrayList<String>(Arrays.asList(this.m_Owner.getCustomColumnHeaders().trim().split(",")));
                                    if (cells.size() != this.m_HeaderCells.size()) {
                                        throw new IllegalStateException("Number of cells of custom header differs from data: " + this.m_HeaderCells.size() + " != " + cells.size());
                                    }
                                } else {
                                    this.m_HeaderCells = new ArrayList<String>();
                                    for (i = 0; i < cells.size(); ++i) {
                                        this.m_HeaderCells.add("Col" + (i + 1));
                                    }
                                }
                                row = result.getHeaderRow();
                                for (i = 0; i < this.m_HeaderCells.size(); ++i) {
                                    row.addCell("" + i).setContent(this.m_HeaderCells.get(i));
                                }
                                row = result.addRow();
                            } else {
                                if (this.m_Owner.getCustomColumnHeaders().trim().length() > 0) {
                                    this.m_HeaderCells = new ArrayList<String>(Arrays.asList(this.m_Owner.getCustomColumnHeaders().trim().split(",")));
                                    if (cells.size() != this.m_HeaderCells.size()) {
                                        throw new IllegalStateException("Number of cells of custom header differs from data: " + this.m_HeaderCells.size() + " != " + cells.size());
                                    }
                                } else {
                                    this.m_HeaderCells = cells;
                                }
                                row = result.getHeaderRow();
                            }
                            this.m_Owner.getTextColumns().setMax(this.m_HeaderCells.size());
                            this.m_Owner.getDateTimeColumns().setMax(this.m_HeaderCells.size());
                            this.m_Owner.getDateColumns().setMax(this.m_HeaderCells.size());
                            this.m_Owner.getTimeColumns().setMax(this.m_HeaderCells.size());
                            this.m_HasTextCols = this.m_Owner.getTextColumns().getIntIndices().length > 0;
                            this.m_HasDateTimeCols = this.m_Owner.getDateTimeColumns().getIntIndices().length > 0;
                            this.m_HasDateCols = this.m_Owner.getDateColumns().getIntIndices().length > 0;
                            this.m_HasTimeCols = this.m_Owner.getTimeColumns().getIntIndices().length > 0;
                        } else {
                            isHeader = false;
                            row = result.addRow();
                        }
                        for (i = 0; i < this.m_HeaderCells.size() && i < cells.size(); ++i) {
                            if (cells.get(i).equals(this.m_Owner.getMissingValue())) continue;
                            if (isHeader) {
                                row.addCell("" + i).setContentAsString(cells.get(i));
                                continue;
                            }
                            if (this.m_HasTextCols && this.m_Owner.getTextColumns().isInRange(i)) {
                                row.addCell("" + i).setContentAsString(cells.get(i));
                                continue;
                            }
                            if (this.m_HasDateTimeCols && this.m_Owner.getDateTimeColumns().isInRange(i) && this.m_DateTimeFormat.check(cells.get(i))) {
                                row.addCell("" + i).setContent(new DateTime(this.m_DateTimeFormat.parse(cells.get(i))));
                                continue;
                            }
                            if (this.m_HasDateCols && this.m_Owner.getDateColumns().isInRange(i) && this.m_DateFormat.check(cells.get(i))) {
                                row.addCell("" + i).setContent(this.m_DateFormat.parse(cells.get(i)));
                                continue;
                            }
                            if (this.m_HasTimeCols && this.m_Owner.getTimeColumns().isInRange(i) && this.m_TimeFormat.check(cells.get(i))) {
                                row.addCell("" + i).setContent(new Time(this.m_TimeFormat.parse(cells.get(i))));
                                continue;
                            }
                            row.addCell("" + i).setContent(cells.get(i));
                        }
                        if (isHeader) {
                            this.m_Header = result.getHeader();
                        }
                        if (this.m_ChunkSize <= 0 || result.getRowCount() != this.m_ChunkSize) continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                result = null;
                this.m_Owner.getSystemErr().printStackTrace("Failed to read data!", e);
            }
            return result;
        }

        public boolean hasNext() {
            return this.m_Reader != null;
        }

        public SpreadSheet read(Reader r, int chunkSize) {
            this.m_Reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
            this.m_Header = null;
            this.m_HeaderCells = null;
            this.m_ChunkSize = chunkSize;
            this.m_Separator = Utils.unbackQuoteChars(this.m_Owner.getSeparator()).charAt(0);
            this.m_HasTextCols = false;
            this.m_HasDateTimeCols = false;
            this.m_HasDateCols = false;
            this.m_HasTimeCols = false;
            this.m_DateTimeFormat = this.m_Owner.getDateTimeFormat().toDateFormat();
            this.m_DateTimeFormat.setLenient(this.m_Owner.isDateTimeLenient());
            this.m_DateTimeFormat.setTimeZone(this.m_Owner.getTimeZone());
            this.m_DateFormat = this.m_Owner.getDateFormat().toDateFormat();
            this.m_DateFormat.setLenient(this.m_Owner.isDateLenient());
            this.m_DateFormat.setTimeZone(this.m_Owner.getTimeZone());
            this.m_TimeFormat = this.m_Owner.getTimeFormat().toDateFormat();
            this.m_TimeFormat.setLenient(this.m_Owner.isTimeLenient());
            this.m_TimeFormat.setTimeZone(this.m_Owner.getTimeZone());
            this.m_NumberFormat = LocaleHelper.getSingleton().getNumberFormat(this.m_Owner.getLocale());
            return this.next();
        }
    }
}

