/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.management.LocaleHelper;
import adams.core.management.OptionHandlingLocaleSupporter;
import adams.data.io.output.AbstractSpreadSheetWriterWithMissingValueSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class AbstractFormattedSpreadSheetWriter
extends AbstractSpreadSheetWriterWithMissingValueSupport
implements OptionHandlingLocaleSupporter {
    private static final long serialVersionUID = -9100041207747021318L;
    protected Locale m_Locale;
    protected String m_NumberFormat;
    protected transient NumberFormat m_Formatter;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("locale", "locale", LocaleHelper.getSingleton().getDefault());
        this.m_OptionManager.add("number-format", "numberFormat", this.getDefaultNumberFormat());
    }

    @Override
    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    @Override
    public Locale getLocale() {
        return this.m_Locale;
    }

    @Override
    public String localeTipText() {
        return "The locale to use for formatting the numbers.";
    }

    protected String getDefaultNumberFormat() {
        return "";
    }

    public void setNumberFormat(String value) {
        this.m_NumberFormat = value;
        this.reset();
    }

    public String getNumberFormat() {
        return this.m_NumberFormat;
    }

    public String numberFormatTipText() {
        return "The format for the numbers (see java.text.DecimalFormat), use empty string for default 'double' output.";
    }

    protected synchronized String format(double value) {
        String result;
        if (this.m_NumberFormat.length() > 0) {
            if (this.m_Formatter == null) {
                try {
                    this.m_Formatter = LocaleHelper.getSingleton().getNumberFormat(this.m_Locale);
                    ((DecimalFormat)this.m_Formatter).applyPattern(this.m_NumberFormat);
                }
                catch (Exception e) {
                    this.getSystemErr().println("Failed to initialize formatter with format '" + this.m_NumberFormat + "':");
                    this.getSystemErr().printStackTrace(e);
                    this.m_Formatter = LocaleHelper.getSingleton().getNumberFormat(this.m_Locale);
                }
            }
            result = this.m_Formatter.format(value);
        } else {
            result = Utils.doubleToString(value, 12, this.m_Locale);
        }
        return result;
    }
}

