/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.data.io.output.AbstractFormattedSpreadSheetWriter;
import adams.data.io.output.AppendableSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriterWithFormulaSupport;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.Writer;

public class CsvSpreadSheetWriter
extends AbstractFormattedSpreadSheetWriter
implements AppendableSpreadSheetWriter,
SpreadSheetWriterWithFormulaSupport {
    private static final long serialVersionUID = -3549185519778801930L;
    protected boolean m_Appending;
    protected SpreadSheet m_Header;
    protected boolean m_KeepExisting;
    protected boolean m_FileExists;
    protected boolean m_OutputAsDisplayed;
    protected String m_Separator;
    protected boolean m_AlwaysQuoteText;

    @Override
    public String globalInfo() {
        return "Writes CSV files.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-as-displayed", "outputAsDisplayed", false);
        this.m_OptionManager.add("appending", "appending", false);
        this.m_OptionManager.add("keep-existing", "keepExisting", false);
        this.m_OptionManager.add("separator", "separator", ",");
        this.m_OptionManager.add("always-quote-text", "alwaysQuoteText", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Header = null;
        this.m_FileExists = false;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Header = null;
        this.m_FileExists = false;
    }

    @Override
    public void setOutputAsDisplayed(boolean value) {
        this.m_OutputAsDisplayed = value;
        this.reset();
    }

    @Override
    public boolean getOutputAsDisplayed() {
        return this.m_OutputAsDisplayed;
    }

    @Override
    public String outputAsDisplayedTipText() {
        return "If enabled, cells are output as displayed, ie, results of formulas instead of the formulas.";
    }

    @Override
    public boolean canAppend(SpreadSheet sheet) {
        if (this.m_Header == null) {
            return this.m_KeepExisting;
        }
        return this.m_Header.equalsHeader(sheet) == null;
    }

    @Override
    public void setAppending(boolean value) {
        this.m_Appending = value;
        this.reset();
    }

    @Override
    public boolean isAppending() {
        return this.m_Appending;
    }

    @Override
    public String appendingTipText() {
        return "If enabled, multiple spreadsheets with the same structure can be written to the same file.";
    }

    @Override
    public void setKeepExisting(boolean value) {
        this.m_KeepExisting = value;
        this.reset();
    }

    @Override
    public boolean getKeepExisting() {
        return this.m_KeepExisting;
    }

    @Override
    public String keepExistingTipText() {
        return "If enabled, any output file that exists when the writer is executed for the first time won't get replaced with the current header; useful when outputting data in multiple locations in the flow, but one needs to be cautious as to not stored mixed content (eg varying number of columns, etc).";
    }

    public void setSeparator(String value) {
        this.m_Separator = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getSeparator() {
        return Utils.backQuoteChars(this.m_Separator);
    }

    public String separatorTipText() {
        return "The separator to use for the columns; use '\\t' for tab.";
    }

    public void setAlwaysQuoteText(boolean value) {
        this.m_AlwaysQuoteText = value;
        this.reset();
    }

    public boolean getAlwaysQuoteText() {
        return this.m_AlwaysQuoteText;
    }

    public String alwaysQuoteTextTipText() {
        return "If enabled, text/formula cells always get surrounded by double quotes.";
    }

    @Override
    public void setFileExists(boolean value) {
        this.m_FileExists = value;
    }

    @Override
    public boolean getFileExists() {
        return this.m_FileExists;
    }

    @Override
    public String getFormatDescription() {
        return "Comma-separated values files";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"csv"};
    }

    @Override
    protected boolean getUseOutputStream() {
        return false;
    }

    protected String quoteString(String s) {
        boolean required = this.m_AlwaysQuoteText || s.contains(this.m_Separator) || s.contains(" ") || s.contains("\"") || s.length() == 0;
        String result = required ? Utils.doubleUpQuotes(s, '\"', new char[]{'\t'}, new String[]{"\\t"}) : s;
        return result;
    }

    protected String quoteNumber(String s) {
        boolean required = s.contains(this.m_Separator) || s.length() == 0;
        String result = required ? Utils.doubleUpQuotes(s, '\"', new char[]{'\t'}, new String[]{"\\t"}) : s;
        return result;
    }

    @Override
    protected boolean doWrite(SpreadSheet content, Writer writer) {
        boolean result = true;
        try {
            Cell cell;
            boolean first;
            String newline = System.getProperty("line.separator");
            DateFormat dformat = content.getDateFormat();
            DateFormat dtformat = content.getDateTimeFormat();
            DateFormat tformat = content.getTimeFormat();
            if (this.m_Header == null) {
                if (!this.m_FileExists || !this.m_KeepExisting) {
                    for (int i = 0; i < content.getComments().size(); ++i) {
                        writer.write("# " + content.getComments().get(i) + newline);
                    }
                    first = true;
                    for (String key : content.getHeaderRow().cellKeys()) {
                        cell = content.getHeaderRow().getCell(key);
                        if (!first) {
                            writer.write(this.m_Separator);
                        }
                        if (cell.isMissing()) {
                            writer.write(this.quoteString(this.m_MissingValue));
                        } else {
                            writer.write(this.quoteString(cell.getContent()));
                        }
                        first = false;
                    }
                    writer.write(newline);
                }
                if (this.m_Appending) {
                    this.m_Header = content.getHeader();
                }
            }
            for (DataRow row : content.rows()) {
                first = true;
                for (String keyd : content.getHeaderRow().cellKeys()) {
                    cell = row.getCell(keyd);
                    if (!first) {
                        writer.write(this.m_Separator);
                    }
                    if (cell != null && cell.getContent() != null && !cell.isMissing()) {
                        if (cell.isFormula() && !this.m_OutputAsDisplayed) {
                            writer.write(this.quoteString(cell.getFormula()));
                        } else {
                            switch (cell.getContentType()) {
                                case STRING: {
                                    writer.write(this.quoteString(cell.getContent()));
                                    break;
                                }
                                case LONG: {
                                    writer.write(this.quoteNumber(cell.toLong().toString()));
                                    break;
                                }
                                case DOUBLE: {
                                    writer.write(this.quoteNumber(this.format(cell.toDouble())));
                                    break;
                                }
                                case DATE: {
                                    writer.write(this.quoteString(dformat.format(cell.toDate())));
                                    break;
                                }
                                case DATETIME: {
                                    writer.write(this.quoteString(dtformat.format(cell.toDateTime())));
                                    break;
                                }
                                case TIME: {
                                    writer.write(this.quoteString(tformat.format(cell.toTime())));
                                    break;
                                }
                                case BOOLEAN: {
                                    writer.write(this.quoteString(cell.toBoolean().toString()));
                                    break;
                                }
                                default: {
                                    writer.write(this.quoteString(cell.toString()));
                                    break;
                                }
                            }
                        }
                    } else {
                        writer.write(this.quoteString(this.m_MissingValue));
                    }
                    first = false;
                }
                writer.write(newline);
            }
        }
        catch (Exception e) {
            result = false;
            this.getSystemErr().printStackTrace("Failed writing spreadsheet data", e);
        }
        return result;
    }
}

