/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.data.container.DataContainer;
import adams.data.report.AbstractField;
import adams.data.report.AbstractReportFilter;
import adams.data.report.DataType;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import java.util.Arrays;
import java.util.HashSet;

public class RemoveByDataType
extends AbstractReportFilter {
    private static final long serialVersionUID = 2459960819587891448L;
    protected DataType[] m_DataTypes;
    protected boolean m_InvertMatching;

    @Override
    public String globalInfo() {
        return "Removes all fields from the report that match the defined data types. If matching is inverted, the filter keeps all defined data types instead and removes all others.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-type", "dataTypes", new DataType[0]);
        this.m_OptionManager.add("invert-matching", "invertMatching", false);
    }

    public void setDataTypes(DataType[] value) {
        this.m_DataTypes = value;
        this.reset();
    }

    public DataType[] getDataTypes() {
        return this.m_DataTypes;
    }

    public String dataTypesTipText() {
        return "The data types to remove (or keep, if matching is inverted).";
    }

    public void setInvertMatching(boolean value) {
        this.m_InvertMatching = value;
        this.reset();
    }

    public boolean getInvertMatching() {
        return this.m_InvertMatching;
    }

    public String invertMatchingTipText() {
        return "If enabled the data types are retained rather than deleted, all that aren't listed are then removed instead.";
    }

    protected DataContainer processData(DataContainer data) {
        if (!(data instanceof MutableReportHandler)) {
            return data;
        }
        Object oldReport = ((MutableReportHandler)((Object)data)).getReport();
        Report newReport = Report.newInstance(oldReport);
        HashSet<DataType> types = new HashSet<DataType>(Arrays.asList(DataType.values()));
        for (AbstractField field : ((Report)oldReport).getFields()) {
            if (this.m_InvertMatching) {
                if (!types.contains(field.getDataType())) continue;
                newReport.addField(field);
                newReport.setValue(field, ((Report)oldReport).getValue(field));
                continue;
            }
            if (types.contains(field.getDataType())) continue;
            newReport.addField(field);
            newReport.setValue(field, ((Report)oldReport).getValue(field));
        }
        ((MutableReportHandler)((Object)data)).setReport(newReport);
        return data;
    }
}

