/*
 * Decompiled with CFR 0.152.
 */
package adams.data.sequence;

import adams.data.container.AbstractDataContainer;
import adams.data.container.DataPointComparator;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.data.sequence.XYSequenceUtils;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import java.util.ArrayList;

public class XYSequence<X extends Number, Y extends Number>
extends AbstractDataContainer<XYSequencePoint<X, Y>>
implements SpreadSheetSupporter {
    private static final long serialVersionUID = -3742507986126404535L;
    public static final String FILE_EXTENSION = ".csv";
    protected DataPointComparator m_Comparator;
    protected XYSequencePointComparator.Comparison m_Comparison;
    protected XYSequencePoint<X, Y> m_MinX;
    protected XYSequencePoint<X, Y> m_MaxX;
    protected XYSequencePoint<X, Y> m_MinY;
    protected XYSequencePoint<X, Y> m_MaxY;

    public XYSequence() {
        this.invalidateMinMax();
        this.setComparison(XYSequencePointComparator.Comparison.X);
    }

    public void setComparison(XYSequencePointComparator.Comparison value) {
        this.m_Comparison = value;
        this.m_Comparator = this.newComparator();
    }

    public XYSequencePointComparator.Comparison getComparison() {
        return this.m_Comparison;
    }

    @Override
    public DataPointComparator<XYSequencePoint<X, Y>> newComparator() {
        return new XYSequencePointComparator(this.m_Comparison, true);
    }

    @Override
    public DataPointComparator<XYSequencePoint<X, Y>> getComparator() {
        return this.m_Comparator;
    }

    @Override
    public XYSequencePoint<X, Y> newPoint() {
        return new XYSequencePoint();
    }

    @Override
    protected boolean modifiedListener(boolean modified) {
        this.invalidateMinMax();
        return modified;
    }

    protected void invalidateMinMax() {
        this.m_MinX = null;
        this.m_MaxX = null;
        this.m_MinY = null;
        this.m_MaxY = null;
    }

    protected synchronized void validateMinMax() {
        if (this.m_MinX != null) {
            return;
        }
        for (XYSequencePoint point : this) {
            if (this.m_MinX == null || ((Comparable)point.getX()).compareTo(this.m_MinX.getX()) < 0) {
                this.m_MinX = point;
            }
            if (this.m_MaxX == null || ((Comparable)point.getX()).compareTo(this.m_MaxX.getX()) > 0) {
                this.m_MaxX = point;
            }
            if (this.m_MinY == null || ((Comparable)point.getY()).compareTo(this.m_MinY.getY()) < 0) {
                this.m_MinY = point;
            }
            if (this.m_MaxY != null && ((Comparable)point.getY()).compareTo(this.m_MaxY.getY()) <= 0) continue;
            this.m_MaxY = point;
        }
    }

    public XYSequencePoint<X, Y> getMinX() {
        this.validateMinMax();
        return this.m_MinX;
    }

    public XYSequencePoint<X, Y> getMaxX() {
        this.validateMinMax();
        return this.m_MaxX;
    }

    public XYSequencePoint<X, Y> getMinY() {
        this.validateMinMax();
        return this.m_MinY;
    }

    public XYSequencePoint<X, Y> getMaxY() {
        this.validateMinMax();
        return this.m_MaxY;
    }

    public XYSequencePoint<X, Y> find(X x) {
        XYSequencePoint result = null;
        ArrayList<XYSequencePoint> points = new ArrayList<XYSequencePoint>(this.m_Points);
        int index = XYSequenceUtils.findX(points, x);
        if (index > -1) {
            result = (XYSequencePoint)this.m_Points.get(index);
        }
        return result;
    }

    public XYSequencePoint<X, Y> findClosest(X x) {
        XYSequencePoint result = null;
        ArrayList<XYSequencePoint> points = new ArrayList<XYSequencePoint>(this.m_Points);
        int index = XYSequenceUtils.findClosestX(points, x);
        if (index > -1) {
            result = (XYSequencePoint)this.m_Points.get(index);
        }
        return result;
    }

    @Override
    public SpreadSheet toSpreadSheet() {
        SpreadSheet result = new SpreadSheet();
        Row row = result.getHeaderRow();
        row.addCell("ID").setContent("ID");
        row.addCell("X").setContent("X");
        row.addCell("Y").setContent("Y");
        for (XYSequencePoint point : this) {
            row = result.addRow();
            row.addCell("ID").setContent(point.getID());
            row.addCell("X").setContent(((Number)point.getX()).doubleValue());
            row.addCell("Y").setContent(((Number)point.getY()).doubleValue());
        }
        return result;
    }
}

