/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.DateTime;
import adams.core.Time;
import adams.core.Utils;
import adams.data.spreadsheet.AbstractObjectHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.parser.SpreadSheetFormula;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;

public class Cell
implements Serializable {
    private static final long serialVersionUID = -3912508808391288142L;
    public static final String PREFIX_FORMULA = "=";
    public static final String FORMULA_ERROR = "#ERROR#";
    protected Row m_Owner;
    protected double m_Content;
    protected String m_Formula;
    protected Object m_Object;
    protected ContentType m_ContentType;

    public Cell(Row owner) {
        this.m_Owner = owner;
        this.m_Formula = null;
        this.m_Object = null;
        this.setContentAsString("");
    }

    public void setOwner(Row owner) {
        this.m_Owner = owner;
    }

    public Row getOwner() {
        return this.m_Owner;
    }

    public SpreadSheet getSpreadSheet() {
        return this.getOwner().getOwner();
    }

    public void assign(Cell cell) {
        this.m_ContentType = cell.m_ContentType;
        if (cell.isFormula()) {
            this.setFormula(cell.getFormula());
        } else if (cell.isObject()) {
            this.setObject(cell.getObject());
        } else {
            switch (this.m_ContentType) {
                case STRING: {
                    this.setContentAsString(cell.getContent());
                    break;
                }
                default: {
                    this.m_Content = cell.m_Content;
                }
            }
        }
    }

    public void setMissing() {
        this.m_Content = Double.NaN;
        this.m_Formula = null;
        this.m_Object = null;
        this.m_ContentType = ContentType.MISSING;
    }

    public void setContent(Boolean value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value != false ? 1 : 0;
            this.m_ContentType = ContentType.BOOLEAN;
        }
    }

    public void setContent(Byte value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.longValue();
            this.m_ContentType = ContentType.LONG;
        }
    }

    public void setContent(Short value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.longValue();
            this.m_ContentType = ContentType.LONG;
        }
    }

    public void setContent(Integer value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.longValue();
            this.m_ContentType = ContentType.LONG;
        }
    }

    public void setContent(Long value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.longValue();
            this.m_ContentType = ContentType.LONG;
        }
    }

    public void setContent(Float value) {
        if (value == null || Float.isNaN(value.floatValue())) {
            this.setMissing();
        } else {
            this.m_Content = value.floatValue();
            this.m_ContentType = ContentType.DOUBLE;
        }
    }

    public void setContent(Double value) {
        if (value == null || Double.isNaN(value)) {
            this.setMissing();
        } else {
            this.m_Content = value;
            this.m_ContentType = ContentType.DOUBLE;
        }
    }

    public void setContent(Date value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.getTime();
            this.m_ContentType = ContentType.DATE;
        }
    }

    public void setContent(DateTime value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.getTime();
            this.m_ContentType = ContentType.DATETIME;
        }
    }

    public void setContent(Time value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = value.getTime();
            this.m_ContentType = ContentType.TIME;
        }
    }

    protected boolean checkTime(String s) {
        if (s.indexOf(58) > -1) {
            return this.getSpreadSheet().getTimeFormat().check(s);
        }
        return false;
    }

    protected boolean checkDate(String s) {
        if (s.indexOf(45) > -1) {
            return this.getSpreadSheet().getDateFormat().check(s);
        }
        return false;
    }

    protected boolean checkDateTime(String s) {
        if (s.indexOf(45) > -1 && s.indexOf(58) > -1) {
            return this.getSpreadSheet().getDateTimeFormat().check(s);
        }
        return false;
    }

    protected boolean checkLong(String s) {
        return Utils.isLong(s);
    }

    protected boolean checkDouble(String s) {
        return Utils.isDouble(s, this.getSpreadSheet().getLocale());
    }

    protected void parseContent(String value) {
        if (this.checkDateTime(value)) {
            this.setContent(new DateTime(this.getSpreadSheet().getDateTimeFormat().parse(value)));
        } else if (this.checkTime(value)) {
            this.setContent(new Time(this.getSpreadSheet().getTimeFormat().parse(value).getTime()));
        } else if (this.checkDate(value)) {
            this.setContent(this.getSpreadSheet().getDateFormat().parse(value));
        } else if (this.checkLong(value)) {
            this.setContent(new Long(value));
        } else if (this.checkDouble(value)) {
            try {
                this.setContent(Utils.toDouble(value, this.getSpreadSheet().getLocale()));
            }
            catch (Exception e) {
                this.setContentAsString(null);
            }
        } else {
            this.setContentAsString(value);
        }
    }

    public void setContent(String value) {
        if (value == null || value.equals("?")) {
            this.setMissing();
        } else if (value.length() > 0) {
            if (value.startsWith(PREFIX_FORMULA)) {
                this.m_Formula = value;
                this.m_Object = null;
                this.m_Content = Double.NaN;
            } else {
                this.m_Formula = null;
                this.m_Object = null;
                this.parseContent(value);
            }
        } else {
            this.m_Formula = null;
            this.m_Object = null;
            this.setContentAsString(value);
        }
    }

    public void setContentAsString(String value) {
        if (value == null || value.equals("?")) {
            this.setMissing();
        } else {
            if (value.equals("'?'")) {
                value = "?";
            }
            this.m_Content = this.getSpreadSheet().getSharedStringsTable().getIndex(value);
            this.m_Object = null;
            this.m_ContentType = ContentType.STRING;
        }
    }

    public void setObject(Object value) {
        if (value == null) {
            this.setMissing();
        } else {
            this.m_Content = Double.NaN;
            this.m_Object = value;
            this.m_ContentType = ContentType.OBJECT;
        }
    }

    public void setFormula(String value) {
        if (value == null || value.equals("?")) {
            this.setMissing();
        } else if (!value.startsWith(PREFIX_FORMULA)) {
            this.setContentAsString(value);
        } else {
            this.m_Formula = value;
            this.m_Object = null;
            this.m_Content = Double.NaN;
        }
    }

    public String getFormula() {
        return this.m_Formula;
    }

    public Object getObject() {
        return this.m_Object;
    }

    public String getContent() {
        this.calculateIfRequired();
        switch (this.m_ContentType) {
            case MISSING: {
                return "?";
            }
            case TIME: {
                return this.getSpreadSheet().getTimeFormat().format(new Time((long)this.m_Content));
            }
            case DATE: {
                return this.getSpreadSheet().getDateFormat().format(new Date((long)this.m_Content));
            }
            case DATETIME: {
                return this.getSpreadSheet().getDateTimeFormat().format(new Date((long)this.m_Content));
            }
            case STRING: {
                return this.getSpreadSheet().getSharedStringsTable().getString((int)this.m_Content);
            }
            case LONG: {
                return Long.toString((long)this.m_Content);
            }
            case OBJECT: {
                if (this.m_Object == null) {
                    return "?";
                }
                AbstractObjectHandler handler = AbstractObjectHandler.getHandler(this.m_Object);
                if (handler == null) {
                    return "?";
                }
                return handler.format(this.m_Object);
            }
        }
        return Double.toString(this.m_Content);
    }

    public ContentType getContentType() {
        this.calculateIfRequired();
        return this.m_ContentType;
    }

    public int index() {
        return this.getOwner().indexOf(this);
    }

    public boolean isNumeric() {
        this.calculateIfRequired();
        return this.m_ContentType == ContentType.LONG || this.m_ContentType == ContentType.DOUBLE;
    }

    public boolean isMissing() {
        this.calculateIfRequired();
        return this.m_ContentType == ContentType.MISSING;
    }

    public boolean isBoolean() {
        this.calculateIfRequired();
        return this.m_ContentType == ContentType.BOOLEAN;
    }

    public Boolean toBoolean() {
        this.calculateIfRequired();
        if (this.m_ContentType == ContentType.BOOLEAN) {
            return new Boolean(this.m_Content == 1.0);
        }
        return null;
    }

    public boolean isDate() {
        this.calculateIfRequired();
        return this.m_ContentType == ContentType.DATE;
    }

    public Date toDate() {
        this.calculateIfRequired();
        if (this.m_ContentType == ContentType.DATE) {
            return new Date((long)this.m_Content);
        }
        return null;
    }

    public boolean isDateTime() {
        this.calculateIfRequired();
        return this.m_ContentType == ContentType.DATETIME;
    }

    public DateTime toDateTime() {
        this.calculateIfRequired();
        if (this.m_ContentType == ContentType.DATETIME) {
            return new DateTime((long)this.m_Content);
        }
        return null;
    }

    public boolean isTime() {
        this.calculateIfRequired();
        return this.m_ContentType == ContentType.TIME;
    }

    public Time toTime() {
        this.calculateIfRequired();
        if (this.m_ContentType == ContentType.TIME) {
            return new Time((long)this.m_Content);
        }
        return null;
    }

    public String toString() {
        return this.getContent();
    }

    public boolean isDouble() {
        this.calculateIfRequired();
        if (this.m_ContentType == ContentType.DOUBLE) {
            return true;
        }
        if (this.m_ContentType == ContentType.STRING) {
            return this.checkDouble(this.getContent());
        }
        return false;
    }

    public Double toDouble() {
        this.calculateIfRequired();
        if (this.m_ContentType == ContentType.DOUBLE) {
            return this.m_Content;
        }
        if (this.m_ContentType == ContentType.LONG) {
            return new Double((long)this.m_Content);
        }
        if (this.m_ContentType == ContentType.STRING) {
            try {
                return Utils.toDouble(this.getContent(), this.getSpreadSheet().getLocale());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public boolean isLong() {
        this.calculateIfRequired();
        if (this.m_ContentType == ContentType.LONG) {
            return true;
        }
        if (this.m_ContentType == ContentType.STRING) {
            return Utils.isLong(this.getContent());
        }
        return false;
    }

    public Long toLong() {
        this.calculateIfRequired();
        if (this.m_ContentType == ContentType.LONG) {
            return (long)this.m_Content;
        }
        if (this.m_ContentType == ContentType.STRING) {
            return new Double(this.getContent()).longValue();
        }
        return null;
    }

    public boolean isFormula() {
        return this.m_Formula != null;
    }

    public boolean isObject() {
        return this.m_Object != null;
    }

    public void calculate() {
        String value;
        if (!this.isFormula()) {
            return;
        }
        try {
            double eval = SpreadSheetFormula.evaluate(this.getFormula(), new HashMap(), this.getSpreadSheet());
            if (Double.isNaN(eval)) {
                return;
            }
            value = "" + eval;
        }
        catch (Exception e) {
            System.err.println("Failed to parse formula: " + this.getFormula());
            e.printStackTrace();
            value = FORMULA_ERROR;
        }
        this.parseContent(value);
    }

    protected void calculateIfRequired() {
        if (this.isFormula() && Double.isNaN(this.m_Content)) {
            this.calculate();
        }
    }

    public static enum ContentType {
        MISSING,
        STRING,
        BOOLEAN,
        LONG,
        DOUBLE,
        DATE,
        DATETIME,
        TIME,
        OBJECT;

    }
}

