/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.event.SpreadSheetColumnInsertionEvent;
import java.util.Arrays;
import java.util.Collection;

public class DenseDataRow
implements DataRow {
    private static final long serialVersionUID = -174960053020463008L;
    protected SpreadSheet m_Owner;
    protected Cell[] m_Cells;

    public DenseDataRow(SpreadSheet owner) {
        this.m_Owner = owner;
        this.clear();
    }

    @Override
    public void setOwner(SpreadSheet owner) {
        this.m_Owner = owner;
        if (owner.getColumnCount() != this.m_Cells.length) {
            this.clear();
        }
    }

    @Override
    public SpreadSheet getOwner() {
        return this.m_Owner;
    }

    @Override
    public DataRow getClone(SpreadSheet owner) {
        DenseDataRow result = new DenseDataRow(owner);
        for (int i = 0; i < this.m_Cells.length; ++i) {
            result.m_Cells[i] = new Cell(result);
            result.m_Cells[i].assign(this.m_Cells[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.m_Cells = new Cell[this.getOwner().getColumnCount()];
        for (int i = 0; i < this.m_Cells.length; ++i) {
            this.m_Cells[i] = new Cell(this);
            this.m_Cells[i].setMissing();
        }
    }

    @Override
    public boolean hasCell(int columnIndex) {
        return columnIndex >= 0 && columnIndex < this.m_Cells.length;
    }

    @Override
    public boolean hasCell(String cellKey) {
        return this.getOwner().getHeaderRow().hasCell(cellKey);
    }

    @Override
    public Cell addCell(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.m_Cells.length) {
            return this.m_Cells[columnIndex];
        }
        return null;
    }

    @Override
    public Cell addCell(String cellKey) {
        return this.addCell(this.getOwner().getHeaderRow().indexOf(cellKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Cell removeCell(int columnIndex) {
        Cell result = null;
        if (columnIndex < 0 || columnIndex >= this.m_Cells.length) return result;
        Cell[] cellArray = this.m_Cells;
        synchronized (this.m_Cells) {
            Cell[] cells = new Cell[this.m_Cells.length - 1];
            int n = 0;
            for (int i = 0; i < this.m_Cells.length; ++i) {
                if (i != columnIndex) {
                    cells[n] = this.m_Cells[i];
                    ++n;
                    continue;
                }
                result = this.m_Cells[i];
            }
            this.m_Cells = cells;
            // ** MonitorExit[var6_3] (shouldn't be in output)
            return result;
        }
    }

    @Override
    public Cell removeCell(String cellKey) {
        return this.removeCell(this.getOwner().getHeaderRow().indexOf(cellKey));
    }

    @Override
    public Cell getCell(String cellKey) {
        return this.getCell(this.getOwner().getHeaderRow().indexOf(cellKey));
    }

    @Override
    public Cell getCell(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.m_Cells.length) {
            return this.m_Cells[columnIndex];
        }
        return null;
    }

    @Override
    public String getContent(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.m_Cells.length) {
            return this.m_Cells[columnIndex].getContent();
        }
        return null;
    }

    @Override
    public String getCellKey(int columnIndex) {
        return this.getOwner().getHeaderRow().getCellKey(columnIndex);
    }

    @Override
    public Collection<String> cellKeys() {
        return this.getOwner().getHeaderRow().cellKeys();
    }

    @Override
    public Collection<Cell> cells() {
        return Arrays.asList(this.m_Cells);
    }

    @Override
    public int getCellCount() {
        return this.m_Cells.length;
    }

    @Override
    public boolean removeMissing() {
        return false;
    }

    @Override
    public int indexOf(Cell cell) {
        int result = -1;
        for (int i = 0; i < this.m_Cells.length; ++i) {
            if (this.m_Cells[i] != cell) continue;
            result = i;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spreadSheetColumnInserted(SpreadSheetColumnInsertionEvent e) {
        Cell[] cellArray = this.m_Cells;
        synchronized (this.m_Cells) {
            Cell[] cells = new Cell[this.m_Cells.length + 1];
            int n = 0;
            cells[e.getColumnIndex()] = new Cell(this);
            for (int i = 0; i < this.m_Cells.length; ++i) {
                if (i == e.getColumnIndex()) {
                    ++n;
                }
                cells[n] = this.m_Cells[i];
                ++n;
            }
            this.m_Cells = cells;
            // ** MonitorExit[var5_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < this.m_Cells.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.m_Cells[i].toString());
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public void mergeWith(Row other) {
        if (this.m_Cells.length != this.getOwner().getColumnCount()) {
            Cell[] cellsNew = new Cell[this.getOwner().getColumnCount()];
            System.arraycopy(this.m_Cells, 0, cellsNew, 0, this.m_Cells.length);
            this.m_Cells = cellsNew;
        }
        int start = this.m_Cells.length - other.getCellCount();
        for (int i = 0; i < other.getOwner().getColumnCount(); ++i) {
            this.m_Cells[start + i] = new Cell(this);
            if (!other.hasCell(i) || other.getCell(i).isMissing()) {
                this.m_Cells[start + i].setMissing();
                continue;
            }
            this.m_Cells[start + i].assign(other.getCell(i));
        }
    }
}

