/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.Range;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RowIdentifier
implements Serializable {
    private static final long serialVersionUID = 2071633034869909763L;
    public static final String SEPARATOR = "\t";
    public static final String MISSING = "missing";
    protected Range m_Columns;
    protected HashMap<String, ArrayList<Integer>> m_Rows;
    protected ArrayList<String> m_Keys;

    public RowIdentifier(Range keys) {
        this.m_Columns = new Range(keys.getRange());
        this.m_Rows = new HashMap();
        this.m_Keys = new ArrayList();
    }

    protected String generateKey(SpreadSheet sheet, int index, int[] indices) {
        HeaderRow header = sheet.getHeaderRow();
        DataRow row = sheet.getRow(index);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < indices.length; ++i) {
            String cellKey = header.getCellKey(indices[i]);
            if (i > 0) {
                result.append(SEPARATOR);
            }
            if (row.hasCell(cellKey) && !row.getCell(cellKey).isMissing()) {
                result.append(row.getCell(cellKey).getContent());
                continue;
            }
            result.append(MISSING);
        }
        return result.toString();
    }

    public void identify(SpreadSheet sheet) {
        this.m_Columns.setMax(sheet.getColumnCount());
        int[] indices = this.m_Columns.getIntIndices();
        this.m_Rows.clear();
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            String key = this.generateKey(sheet, i, indices);
            if (!this.m_Rows.containsKey(key)) {
                this.m_Rows.put(key, new ArrayList());
                this.m_Keys.add(key);
            }
            this.m_Rows.get(key).add(i);
        }
    }

    public Range getColumns() {
        return this.m_Columns;
    }

    public int size() {
        return this.m_Keys.size();
    }

    public List<String> getKeys() {
        return this.m_Keys;
    }

    public String getKey(int keyIndex) {
        return this.m_Keys.get(keyIndex);
    }

    public List<Integer> getRows(int keyIndex) {
        return this.getRows(this.m_Keys.get(keyIndex));
    }

    public List<Integer> getRows(String key) {
        return this.m_Rows.get(key);
    }

    public String toString() {
        return "cols=" + this.m_Columns + ", size=" + this.size();
    }
}

