/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.data.spreadsheet.AbstractRow;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.event.SpreadSheetColumnInsertionEvent;
import java.util.Collection;
import java.util.Collections;

public class SparseDataRow
extends AbstractRow
implements DataRow {
    private static final long serialVersionUID = 6870041975871526417L;

    public SparseDataRow(SpreadSheet owner) {
        super(owner);
    }

    @Override
    public SpreadSheet getOwner() {
        return this.m_Owner;
    }

    @Override
    public DataRow getClone(SpreadSheet owner) {
        SparseDataRow result = new SparseDataRow(owner);
        for (String key : this.m_Cells.keySet()) {
            Cell cell = new Cell(result);
            cell.assign((Cell)this.m_Cells.get(key));
            cell.setOwner(result);
            result.m_Cells.put(key, cell);
        }
        return result;
    }

    @Override
    public Cell addCell(String cellKey) {
        Cell result;
        if (this.hasCell(cellKey)) {
            result = this.getCell(cellKey);
        } else {
            result = new Cell(this);
            this.m_Cells.put(cellKey, result);
        }
        return result;
    }

    @Override
    public boolean hasCell(int columnIndex) {
        return this.hasCell(this.getOwner().getHeaderRow().getCellKey(columnIndex));
    }

    @Override
    public Cell addCell(int columnIndex) {
        return this.addCell(this.getOwner().getHeaderRow().getCellKey(columnIndex));
    }

    @Override
    public Cell getCell(int columnIndex) {
        Cell result = null;
        String key = this.getCellKey(columnIndex);
        if (key != null) {
            result = this.getCell(key);
        }
        return result;
    }

    @Override
    public String getContent(int columnIndex) {
        String result = null;
        String key = this.getCellKey(columnIndex);
        if (key != null) {
            result = this.getCell(key).getContent();
        }
        return result;
    }

    @Override
    public String getCellKey(int columnIndex) {
        return this.getOwner().getHeaderRow().getCellKey(columnIndex);
    }

    @Override
    public Collection<String> cellKeys() {
        return Collections.unmodifiableCollection(this.m_Cells.keySet());
    }

    @Override
    public Collection<Cell> cells() {
        return this.m_Cells.values();
    }

    @Override
    public int indexOf(Cell cell) {
        int result = -1;
        if (cell.getOwner() == this && this.m_Cells.containsValue(cell)) {
            for (String key : this.m_Cells.keySet()) {
                if (this.m_Cells.get(key) != cell) continue;
                result = this.getOwner().getHeaderRow().indexOf(key);
                break;
            }
        }
        return result;
    }

    @Override
    public void spreadSheetColumnInserted(SpreadSheetColumnInsertionEvent e) {
    }

    @Override
    public void mergeWith(Row other) {
        int start = this.getOwner().getColumnCount();
        for (int i = 0; i < other.getOwner().getColumnCount(); ++i) {
            if (!other.hasCell(i)) continue;
            this.addCell(start + i).assign(other.getCell(i));
        }
    }
}

