/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.ClassLister;
import adams.core.Properties;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.env.Environment;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;

public abstract class AbstractTable
extends SQL
implements DatabaseConnectionChangeListener {
    private static final long serialVersionUID = 4511302757992864994L;
    protected static Properties m_Properties;
    protected String m_TableName;

    public AbstractTable(AbstractDatabaseConnection dbcon, String tableName) {
        super(dbcon);
        this.m_TableName = tableName;
        this.m_DatabaseConnection.addChangeListener(this);
        this.setDebug(AbstractTable.getProperties().getBoolean(this.getClass().getName() + ".Debug", false));
        if (this.getDebug()) {
            this.debug(this.m_DatabaseConnection.toString());
        }
    }

    public static boolean isEnabled(Class cls) {
        return AbstractTable.getProperties().getBoolean(cls.getName() + ".Enabled", false);
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public boolean tableExists() {
        return this.tableExists(this.getTableName());
    }

    public boolean columnExists(String column) {
        return this.columnExists(this.getTableName(), column);
    }

    public abstract boolean init();

    @Override
    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
    }

    @Override
    public String toString() {
        return this.getTableName() + ": " + this.getDatabaseConnection().toString();
    }

    public static String[] getTables() {
        return ClassLister.getSingleton().getClassnames(AbstractTable.class);
    }

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("table");
        }
        return m_Properties;
    }
}

