/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.DateUtils;
import adams.core.base.BaseDateTime;
import adams.db.AbstractTableCleanUp;

public abstract class AbstractTimeWindowTableCleanUp
extends AbstractTableCleanUp {
    private static final long serialVersionUID = 2617358965818813327L;
    protected BaseDateTime m_StartDate;
    protected BaseDateTime m_EndDate;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "startDate", BaseDateTime.infinityPast());
        this.m_OptionManager.add("end", "endDate", BaseDateTime.infinityFuture());
    }

    public void setStartDate(BaseDateTime value) {
        this.m_StartDate = value;
        this.reset();
    }

    public BaseDateTime getStartDate() {
        return this.m_StartDate;
    }

    public String startDateTipText() {
        return "The start date for the clean-up (yyyy-MM-dd HH:mm:ss).";
    }

    public void setEndDate(BaseDateTime value) {
        this.m_EndDate = value;
        this.reset();
    }

    public BaseDateTime getEndDate() {
        return this.m_EndDate;
    }

    public String endDateTipText() {
        return "The end date for the clean-up (yyyy-MM-dd HH:mm:ss).";
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null && DateUtils.isBefore(this.m_StartDate.dateValue(), this.m_EndDate.dateValue())) {
            result = "End date is earlier than start date!";
        }
        return result;
    }
}

