/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.xml;

import adams.doc.xml.AbstractTag;

public abstract class AbstractSimpleTag
extends AbstractTag {
    private static final long serialVersionUID = -2865475570583425896L;
    protected String m_Content;
    protected boolean m_ConvertEntities;

    public AbstractSimpleTag(String tag) {
        this(tag, "");
    }

    public AbstractSimpleTag(String tag, String content) {
        super(tag);
        this.setContent(content);
        this.m_ConvertEntities = true;
    }

    @Override
    public void setAllowsChildren(boolean allows) {
        super.setAllowsChildren(false);
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    public void setContent(String value) {
        if (value == null) {
            value = "";
        }
        this.m_Content = value;
    }

    public String getContent() {
        return this.m_Content;
    }

    @Override
    public boolean hasContent() {
        return this.m_Content.length() > 0;
    }

    public void setConvertEntities(boolean value) {
        this.m_ConvertEntities = value;
    }

    public boolean getConvertEntities() {
        return this.m_ConvertEntities;
    }

    @Override
    protected void appendContent(StringBuilder buffer) {
        if (this.m_ConvertEntities) {
            buffer.append(AbstractSimpleTag.toEntities(this.m_Content));
        } else {
            buffer.append(this.m_Content);
        }
    }
}

