/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class DirectoryExists
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 912094591109587908L;
    protected PlaceholderDirectory m_Directory;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if the directory exists.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("directory", "directory", new PlaceholderDirectory("."));
    }

    public void setDirectory(PlaceholderDirectory value) {
        this.m_Directory = value;
        this.reset();
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Directory;
    }

    public String directoryTipText() {
        return "The directory to look for.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "directory", this.m_Directory, "dir: ");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp(AbstractActor owner) {
        String result = super.setUp(owner);
        if (result == null && this.m_Directory == null) {
            result = "No directory provided!";
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        return this.m_Directory.exists() && this.m_Directory.isDirectory();
    }
}

