/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.random.AbstractRandomNumberGenerator;
import adams.data.random.JavaRandomInt;
import adams.flow.condition.bool.AbstractExpression;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.parser.BooleanExpressionText;
import java.util.HashMap;

public class RandomNumberExpression
extends AbstractExpression {
    private static final long serialVersionUID = 5195367806715940844L;
    protected AbstractRandomNumberGenerator m_Generator;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if the expression evaluates to 'true'.\nThe 'X' in the expression is the number generated by the random number generator.\n\nThe following grammar is used for evaluating the boolean expressions:\n\n" + this.getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", new JavaRandomInt());
    }

    @Override
    public String getQuickInfo() {
        return super.getQuickInfo() + QuickInfoHelper.toString((OptionHandler)this, "generator", this.m_Generator, ", generator: ");
    }

    @Override
    protected BooleanExpressionText getDefaultExpression() {
        return new BooleanExpressionText("X < 500");
    }

    @Override
    public String expressionTipText() {
        return "The expression to evaluate using the current random number obtained from the generator; expressions that consists solely of a variable (eg '@{blah}') get automatically wrapped in parentheses, since the expression string gets interpreted as attached variable instead.";
    }

    public void setGenerator(AbstractRandomNumberGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractRandomNumberGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator that generates a new random number each time a token arrives.";
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        String exp = owner.getVariables().expand(this.getExpression().getValue());
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        symbols.put("X", ((Number)this.m_Generator.next()).doubleValue());
        return this.doEvaluate(exp, symbols);
    }
}

