/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;

public class ReportValueExists
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 3535479178344450842L;
    protected Field m_Field;

    @Override
    public String globalInfo() {
        return "Returns 'true' if the field in the report is present.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", new Field());
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field which existence determines the result of the evaluation.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "field", this.m_Field, "field: ");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{ReportHandler.class, Report.class};
    }

    @Override
    public String setUp(AbstractActor owner) {
        String result = super.setUp(owner);
        if (result == null && this.m_Field == null) {
            result = "No report field provided!";
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        Report report = token.getPayload() instanceof ReportHandler ? ((ReportHandler)token.getPayload()).getReport() : (Report)token.getPayload();
        boolean result = report.hasValue(this.m_Field);
        return result;
    }
}

