/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.test;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionHandler;
import adams.flow.condition.test.AbstractCondition;

public class DirExists
extends AbstractCondition {
    private static final long serialVersionUID = -2604770228945146124L;
    protected PlaceholderDirectory m_Directory;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "Checks whether a specified directory exists.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dir", "directory", new PlaceholderDirectory("."));
        this.m_OptionManager.add("invert", "invert", false);
    }

    public void setDirectory(PlaceholderDirectory value) {
        this.m_Directory = value;
        this.reset();
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Directory;
    }

    public String directoryTipText() {
        return "The directory to look for.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "directory", this.m_Directory, QuickInfoHelper.toString((OptionHandler)this, "invert", this.m_Invert ? "! " : "") + "dir: ");
    }

    @Override
    protected String performTest() {
        if (this.m_Invert) {
            if (this.m_Directory.exists() && this.m_Invert) {
                return "Directory '" + this.m_Directory + "' already exists!";
            }
        } else {
            if (!this.m_Directory.isDirectory()) {
                return "Target '" + this.m_Directory + "' is not a directory or does not exist!";
            }
            if (!this.m_Directory.exists() && !this.m_Invert) {
                return "Directory '" + this.m_Directory + "' does not exist!";
            }
        }
        return null;
    }
}

