/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.test;

import adams.flow.condition.test.AbstractCondition;

public class MultiCondition
extends AbstractCondition {
    private static final long serialVersionUID = -3833261282991705L;
    protected AbstractCondition[] m_Conditions;

    @Override
    public String globalInfo() {
        return "Checks multiple conditions. Stops checking when the first fails.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "subConditions", new AbstractCondition[0]);
    }

    public void setSubConditions(AbstractCondition[] value) {
        this.m_Conditions = value;
        this.reset();
    }

    public AbstractCondition[] getSubConditions() {
        return this.m_Conditions;
    }

    public String subConditionsTipText() {
        return "The conditions to check.";
    }

    @Override
    protected String performTest() {
        String result = null;
        for (int i = 0; i < this.m_Conditions.length; ++i) {
            result = this.m_Conditions[i].getTestResult();
            if (result == null) continue;
            result = "Failed condition #" + (i + 1) + ": " + result;
            break;
        }
        return result;
    }
}

