/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.core.CloneHandler;
import adams.core.Utils;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractContainer
implements Serializable,
CloneHandler<AbstractContainer>,
SpreadSheetSupporter {
    private static final long serialVersionUID = -6949950627956848217L;
    protected Hashtable<String, Object> m_Values;
    protected HashSet<String> m_AdditionalNames;

    protected AbstractContainer() {
        this.checkDefaultConstructor();
        this.m_Values = new Hashtable();
        this.m_AdditionalNames = new HashSet();
    }

    protected void checkDefaultConstructor() {
        try {
            this.getClass().getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(this.getClass().getName() + " does not have default constructor!");
        }
    }

    @Override
    public AbstractContainer getClone() {
        return (AbstractContainer)Utils.deepCopy(this);
    }

    public abstract Enumeration<String> names();

    public Enumeration<String> stored() {
        Vector<String> result = new Vector<String>(this.m_Values.keySet());
        Collections.sort(result);
        return result.elements();
    }

    public boolean hasValue(String name) {
        return this.getValue(name) != null;
    }

    public Object getValue(String name) {
        return this.m_Values.get(name);
    }

    protected boolean isValidName(String name) {
        boolean result = this.m_AdditionalNames.contains(name);
        if (!result) {
            Enumeration<String> names = this.names();
            while (names.hasMoreElements()) {
                if (!names.nextElement().equals(name)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected boolean store(String name, Object value) {
        if (value == null) {
            return false;
        }
        this.m_Values.put(name, value);
        return true;
    }

    public boolean setValue(String name, Object value) {
        if (this.isValidName(name)) {
            return this.store(name, value);
        }
        return false;
    }

    public abstract boolean isValid();

    public boolean addAdditionalName(String name) {
        return this.m_AdditionalNames.add(name);
    }

    public boolean removeAdditionalName(String name) {
        return this.m_AdditionalNames.remove(name);
    }

    public String toString() {
        String result = "";
        Enumeration<String> names = this.stored();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + name + "=" + this.getValue(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpreadSheet toSpreadSheet() {
        SpreadSheet result;
        Hashtable<String, Object> hashtable = this.m_Values;
        synchronized (hashtable) {
            ArrayList<String> names = new ArrayList<String>(this.m_Values.keySet());
            result = new SpreadSheet();
            Row row = result.getHeaderRow();
            row.addCell("name").setContent("Name");
            row.addCell("value").setContent("Value");
            for (int i = 0; i < names.size(); ++i) {
                Object value = this.m_Values.get(names.get(i));
                row = result.addRow("" + result.getRowCount());
                row.addCell("name").setContent(names.get(i));
                if (value == null) {
                    row.addCell("value").setContent("?");
                    continue;
                }
                if (value.getClass().isArray()) {
                    row.addCell("value").setContent(Utils.arrayToString(value));
                    continue;
                }
                if (value instanceof Integer) {
                    row.addCell("value").setContent((Integer)value);
                    continue;
                }
                if (value instanceof Double) {
                    row.addCell("value").setContent((Double)value);
                    continue;
                }
                row.addCell("value").setContent("" + value);
            }
        }
        return result;
    }
}

