/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.ControlActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;

public class Cast
extends AbstractTransformer
implements ControlActor {
    private static final long serialVersionUID = -6615127883045169960L;
    protected String m_Classname;
    protected Class m_ActualClass;

    @Override
    public String globalInfo() {
        return "Casts the incoming data to the specified classname. For arrays, use '[]' at the end.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classname", "classname", "java.lang.Object");
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_ActualClass = null;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "classname", this.m_Classname);
    }

    protected Class toClass(String classname) {
        Class<?> result;
        boolean array = classname.endsWith("[]");
        if (array) {
            classname = classname.substring(classname.length() - 2);
        }
        try {
            result = array ? Array.newInstance(Class.forName(classname), 0).getClass() : Class.forName(classname);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public void setClassname(String value) {
        if (this.toClass(value) != null) {
            this.m_Classname = value;
            this.reset();
        } else {
            this.getSystemErr().println("Failed to instantiate class: " + value);
        }
    }

    public String getClassname() {
        return this.m_Classname;
    }

    public String classnameTipText() {
        return "The classname to cast the incoming data to.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        Class cls = this.toClass(this.getClassname());
        if (cls == null) {
            return new Class[]{Unknown.class};
        }
        return new Class[]{cls};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActualClass = this.toClass(this.getClassname());
            if (this.m_ActualClass == null) {
                result = "Failed to instantiate class '" + this.getClassname() + "'!";
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_OutputToken = new Token(this.m_ActualClass.cast(this.m_InputToken.getPayload()));
        }
        catch (Exception e) {
            result = this.handleException("Failed to cast to '" + this.getClassname() + "': ", e);
        }
        return result;
    }
}

