/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.control.AbstractContainerUpdater;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;

public class PlotContainerUpdater
extends AbstractContainerUpdater {
    private static final long serialVersionUID = 7140175689043000123L;
    protected PlotContainerValue m_ContainerValue;

    @Override
    public String globalInfo() {
        return "Applies all sub-actors to process either the name, the X or the Y value of the plot container.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("container-value", "containerValue", (Object)PlotContainerValue.Y_VALUE);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "containerValue", (Object)this.m_ContainerValue);
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    public void setContainerValue(PlotContainerValue value) {
        switch (value) {
            case PLOT_NAME: {
                this.setContainerValueName("PlotName");
                break;
            }
            case X_VALUE: {
                this.setContainerValueName("X");
                break;
            }
            case Y_VALUE: {
                this.setContainerValueName("Y");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled container value: " + (Object)((Object)value));
            }
        }
        this.m_ContainerValue = value;
        this.reset();
    }

    public PlotContainerValue getContainerValue() {
        return this.m_ContainerValue;
    }

    public String containerValueTipText() {
        return "The type of value to update.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{SequencePlotterContainer.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            Class[] cls = this.m_ContainerValue == PlotContainerValue.PLOT_NAME ? new Class[]{String.class} : new Class[]{Double.class};
            Compatibility comp = new Compatibility();
            if (!comp.isCompatible(((InputConsumer)((Object)this.firstActive())).accepts(), cls)) {
                result = "First active sub-actor does not accept " + cls[0].getName();
            } else if (!comp.isCompatible(((OutputProducer)((Object)this.lastActive())).generates(), cls)) {
                result = "Last active sub-actor does not generate " + cls[0].getName();
            }
        }
        return result;
    }

    public static enum PlotContainerValue {
        PLOT_NAME,
        X_VALUE,
        Y_VALUE;

    }
}

