/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.execution.AbstractGraphicalFlowExecutionListener;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.SortableAndSearchableTable;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public abstract class AbstractFlowExecutionListenerWithTable
extends AbstractGraphicalFlowExecutionListener {
    private static final long serialVersionUID = 9209750914200226213L;
    protected SortableAndSearchableTable m_Table;
    protected SpreadSheetFileChooser m_FileChooser;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Table = null;
    }

    protected abstract TableModel createTableModel();

    @Override
    public BasePanel newListenerPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        this.m_Table = new SortableAndSearchableTable(this.createTableModel());
        this.m_Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    AbstractFlowExecutionListenerWithTable.this.showPopupMenu(e);
                }
            }
        });
        result.add((Component)new BaseScrollPane(this.m_Table), "Center");
        return result;
    }

    protected synchronized SpreadSheetFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
            this.m_FileChooser.setMultiSelectionEnabled(false);
        }
        return this.m_FileChooser;
    }

    public SpreadSheet getSheet() {
        int n;
        SpreadSheet result = new SpreadSheet();
        result.setDataRowClass(DenseDataRow.class);
        Row row = result.getHeaderRow();
        for (n = 0; n < this.m_Table.getColumnCount(); ++n) {
            row.addCell("" + n).setContent(this.m_Table.getColumnName(n));
        }
        for (int i = 0; i < this.m_Table.getRowCount(); ++i) {
            row = result.addRow();
            for (n = 0; n < this.m_Table.getColumnCount(); ++n) {
                Object value = this.m_Table.getValueAt(i, n);
                Cell cell = row.addCell(n);
                if (value == null) {
                    cell.setMissing();
                    continue;
                }
                cell.setContent(value.toString());
            }
        }
        return result;
    }

    protected void showPopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.m_Table.getSelectedRowCount() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFlowExecutionListenerWithTable.this.m_Table.copyToClipboard();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Save as...");
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VFSJFileChooser.RETURN_TYPE ret = AbstractFlowExecutionListenerWithTable.this.getFileChooser().showSaveDialog(AbstractFlowExecutionListenerWithTable.this.m_Table);
                if (ret != VFSJFileChooser.RETURN_TYPE.APPROVE) {
                    return;
                }
                File file = AbstractFlowExecutionListenerWithTable.this.getFileChooser().getSelectedFile();
                SpreadSheetWriter writer = AbstractFlowExecutionListenerWithTable.this.getFileChooser().getWriter();
                if (!writer.write(AbstractFlowExecutionListenerWithTable.this.getSheet(), file)) {
                    GUIHelper.showErrorMessage(AbstractFlowExecutionListenerWithTable.this.m_Table, "Failed to save spreadsheet to the following file:\n" + file);
                }
            }
        });
        menu.add(menuitem);
        menu.show(this.m_Table, e.getX(), e.getY());
    }

    @Override
    protected void updateGUI() {
        if (this.m_Table != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    AbstractFlowExecutionListenerWithTable.this.m_Table.setModel(AbstractFlowExecutionListenerWithTable.this.createTableModel());
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }
}

