/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractModifyingProcessor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public abstract class AbstractNameUpdater<T>
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = 7133896476260133469L;
    protected String m_OldName;
    protected String m_NewName;

    @Override
    public abstract String globalInfo();

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("old-name", "oldName", "");
        this.m_OptionManager.add("new-name", "newName", "");
    }

    public void setOldName(String value) {
        this.m_OldName = value;
        this.reset();
    }

    public String getOldName() {
        return this.m_OldName;
    }

    public abstract String oldNameTipText();

    public void setNewName(String value) {
        this.m_NewName = value;
        this.reset();
    }

    public String getNewName() {
        return this.m_NewName;
    }

    public abstract String newNameTipText();

    protected abstract boolean isBaseClassMatch(Class var1);

    protected abstract boolean isNameMatch(T var1, String var2);

    protected abstract T getReplacement(T var1, String var2);

    protected void processArgumentOption(AbstractArgumentOption option) {
        if (this.isBaseClassMatch(option.getBaseClass())) {
            Object current = option.getCurrentValue();
            Method method = option.getDescriptor().getWriteMethod();
            boolean update = false;
            if (option.isMultiple()) {
                for (int i = 0; i < Array.getLength(current); ++i) {
                    Object element = Array.get(current, i);
                    if (!this.isNameMatch(element, this.m_OldName) || (element = this.getReplacement(element, this.m_NewName)) == null) continue;
                    Array.set(current, i, element);
                    update = true;
                }
            } else if (this.isNameMatch(current, this.m_OldName)) {
                boolean bl = update = (current = this.getReplacement(current, this.m_NewName)) != null;
            }
            if (update) {
                try {
                    method.invoke((Object)option.getOptionHandler(), current);
                    this.m_Modified = true;
                }
                catch (Exception e) {
                    this.getSystemErr().println("Failed to update property '" + option.getProperty() + "' of '" + option.getOptionHandler().getClass().getName() + "':");
                    this.getSystemErr().printStackTrace(e);
                }
            }
        }
    }

    public boolean canRecurse(Class cls) {
        return !cls.equals(Flow.class);
    }

    public boolean canRecurse(Object obj) {
        return this.canRecurse(obj.getClass());
    }

    @Override
    protected void processActor(AbstractActor actor) {
        actor.getOptionManager().traverse(new OptionTraverser(){

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                AbstractNameUpdater.this.processArgumentOption(option);
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return AbstractNameUpdater.this.canRecurse(cls);
            }

            @Override
            public boolean canRecurse(Object obj) {
                return AbstractNameUpdater.this.canRecurse(obj);
            }
        });
        if (this.m_Modified) {
            this.m_ModifiedActor = actor;
        }
    }
}

