/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.OptionUtils;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CheckProcessor;
import adams.flow.processor.ModifyingProcessor;

public class MultiProcessor
extends AbstractModifyingProcessor
implements CheckProcessor {
    private static final long serialVersionUID = 916259679452752997L;
    protected AbstractActorProcessor[] m_Processors;
    protected StringBuilder m_Warnings;

    @Override
    public String globalInfo() {
        return "A meta-processor that processes the actor sequentially with all sub-processors.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("processor", "subProcessors", new AbstractActorProcessor[0]);
    }

    public void setSubProcessors(AbstractActorProcessor[] value) {
        if (value != null) {
            this.m_Processors = value;
            this.reset();
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": processors cannot be null!");
        }
    }

    public AbstractActorProcessor[] getSubProcessors() {
        return this.m_Processors;
    }

    public String subProcessorsTipText() {
        return "The array of processors to use.";
    }

    @Override
    protected void processActor(AbstractActor actor) {
        AbstractActor input = actor;
        AbstractActor output = actor;
        this.m_Warnings = new StringBuilder();
        for (int i = 0; i < this.m_Processors.length; ++i) {
            CheckProcessor check;
            ModifyingProcessor modifying;
            this.debug("Processor " + (i + 1) + "/" + this.m_Processors.length + ": " + OptionUtils.getCommandLine(this.m_Processors[i]));
            AbstractActorProcessor processor = this.m_Processors[i];
            processor.process(input);
            output = null;
            if (processor.hasErrors()) {
                this.addError("--> " + processor.getClass().getSimpleName(), false);
                for (String error : processor.getErrors()) {
                    this.addError(error, false);
                }
            }
            if (processor instanceof ModifyingProcessor && (modifying = (ModifyingProcessor)((Object)processor)).isModified()) {
                output = modifying.getModifiedActor();
                this.m_Modified = true;
            }
            if (processor instanceof CheckProcessor && (check = (CheckProcessor)((Object)processor)).getWarnings() != null) {
                this.m_Warnings.append("--> " + processor.getClass().getSimpleName() + ":\n");
                if (check.getWarningHeader() != null) {
                    this.m_Warnings.append(check.getWarningHeader() + "\n");
                }
                this.m_Warnings.append(check.getWarnings());
                this.m_Warnings.append("\n\n");
            }
            if (output == null) continue;
            input = output;
        }
        this.debug("Finished!");
    }

    @Override
    public String getWarningHeader() {
        return null;
    }

    @Override
    public String getWarnings() {
        if (this.m_Warnings.length() == 0) {
            return null;
        }
        return this.m_Warnings.toString();
    }
}

