/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.canvas.AbstractDataPoolPostProcessor;
import adams.flow.sink.canvas.DataPoolPaintlet;
import adams.flow.sink.canvas.DataPoolPanel;
import adams.flow.sink.canvas.PassThrough;
import adams.flow.sink.canvas.XYPaintlet;
import adams.gui.core.BasePanel;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.BackgroundImagePaintlet;
import adams.gui.visualization.core.Paintlet;

public class Canvas
extends AbstractGraphicalDisplay {
    private static final long serialVersionUID = -5501727620411611401L;
    protected Paintlet m_BackgroundPaintlet;
    protected DataPoolPaintlet m_Paintlet;
    protected AbstractDataPoolPostProcessor m_PostProcessor;

    @Override
    public String globalInfo() {
        return "General purpose drawing canvas. What kind of data can be drawn depends on the paintlet in use.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("background-paintlet", "backgroundPaintlet", new BackgroundImagePaintlet());
        this.m_OptionManager.add("paintlet", "paintlet", new XYPaintlet());
        this.m_OptionManager.add("post-processor", "postProcessor", new PassThrough());
    }

    public void setBackgroundPaintlet(Paintlet value) {
        if (value.getPaintMoment() != PaintEvent.PaintMoment.BACKGROUND) {
            throw new IllegalArgumentException("Paintlet cannot be used for background!");
        }
        this.m_BackgroundPaintlet = value;
        this.reset();
    }

    public Paintlet getBackgroundPaintlet() {
        return this.m_BackgroundPaintlet;
    }

    public String backgroundPaintletTipText() {
        return "The paintlet to use for plotting the background.";
    }

    public void setPaintlet(DataPoolPaintlet value) {
        this.m_Paintlet = value;
        this.reset();
    }

    public DataPoolPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for plotting the data.";
    }

    public void setPostProcessor(AbstractDataPoolPostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public AbstractDataPoolPostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to use on the data after a token was received and plotted.";
    }

    @Override
    public Class[] accepts() {
        return this.m_Paintlet.accepts();
    }

    @Override
    protected BasePanel newPanel() {
        DataPoolPanel result = new DataPoolPanel();
        Paintlet paintlet = (Paintlet)this.m_Paintlet.shallowCopy(true);
        paintlet.setPanel(result);
        result.addPaintlet(paintlet);
        paintlet = (Paintlet)this.m_BackgroundPaintlet.shallowCopy(true);
        paintlet.setPanel(result);
        result.addPaintlet(paintlet);
        result.setPostProcessor(this.m_PostProcessor.shallowCopy(true));
        return result;
    }

    @Override
    public void clearPanel() {
        if (this.m_Panel != null) {
            ((DataPoolPanel)this.m_Panel).clear();
        }
    }

    @Override
    protected void display(Token token) {
        ((DataPoolPanel)this.m_Panel).addData(token.getPayload());
    }
}

