/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImage;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.image.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JPanel;

public class ImageViewer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 1523870513962160664L;
    protected ImagePanel m_ImagePanel;
    protected double m_Zoom;
    protected Color m_BackgroundColor;
    protected boolean m_ShowProperties;

    @Override
    public String globalInfo() {
        return "Actor for displaying an image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("zoom", "zoom", 100.0);
        this.m_OptionManager.add("background-color", "backgroundColor", this.getDefaultBackgroundColor());
        this.m_OptionManager.add("show-properties", "showProperties", false);
    }

    @Override
    protected int getDefaultWidth() {
        return 640;
    }

    @Override
    protected int getDefaultHeight() {
        return 480;
    }

    protected Color getDefaultBackgroundColor() {
        return new JPanel().getBackground();
    }

    public void setZoom(double value) {
        this.m_Zoom = value;
        this.reset();
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public void setBackgroundColor(Color value) {
        this.m_BackgroundColor = value;
        this.reset();
    }

    public Color getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    public String backgroundColorTipText() {
        return "The background color to use.";
    }

    public void setShowProperties(boolean value) {
        this.m_ShowProperties = value;
        this.reset();
    }

    public boolean getShowProperties() {
        return this.m_ShowProperties;
    }

    public String showPropertiesTipText() {
        return "If enabled then the image properties get displayed.";
    }

    @Override
    public void clearPanel() {
        if (this.m_ImagePanel != null) {
            this.m_ImagePanel.clear();
        }
    }

    @Override
    protected BasePanel newPanel() {
        this.m_ImagePanel = new ImagePanel();
        return this.m_ImagePanel;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class, BufferedImage.class, AbstractImage.class};
    }

    @Override
    protected void display(Token token) {
        if (token.getPayload() instanceof String) {
            this.m_ImagePanel.load(new PlaceholderFile((String)token.getPayload()));
        } else if (token.getPayload() instanceof File) {
            this.m_ImagePanel.load((File)token.getPayload());
        } else if (token.getPayload() instanceof BufferedImage) {
            this.m_ImagePanel.setCurrentImage((BufferedImage)token.getPayload());
        } else if (token.getPayload() instanceof AbstractImage) {
            this.m_ImagePanel.setCurrentImage(((AbstractImage)token.getPayload()).toBufferedImage());
        }
        this.m_ImagePanel.setScale(this.m_Zoom / 100.0);
        this.m_ImagePanel.setShowProperties(this.m_ShowProperties);
        this.m_ImagePanel.setBackgroundColor(this.m_BackgroundColor);
    }

    @Override
    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_ImagePanel != null) {
            this.m_ImagePanel.clear();
        }
    }

    @Override
    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractDisplayPanel result = new AbstractDisplayPanel("Image"){
            private static final long serialVersionUID = 7384093089760722339L;
            protected ImagePanel m_ImagePanel;

            @Override
            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_ImagePanel = new ImagePanel();
                this.add((Component)this.m_ImagePanel, "Center");
            }

            @Override
            public void display(Token token) {
                if (token.getPayload() instanceof String) {
                    this.m_ImagePanel.load(new PlaceholderFile((String)token.getPayload()));
                } else if (token.getPayload() instanceof File) {
                    this.m_ImagePanel.load((File)token.getPayload());
                } else if (token.getPayload() instanceof BufferedImage) {
                    this.m_ImagePanel.setCurrentImage((BufferedImage)token.getPayload());
                } else if (token.getPayload() instanceof AbstractImage) {
                    this.m_ImagePanel.setCurrentImage(((AbstractImage)token.getPayload()).toBufferedImage());
                }
                this.m_ImagePanel.setScale(ImageViewer.this.m_Zoom / 100.0);
                this.m_ImagePanel.setShowProperties(ImageViewer.this.m_ShowProperties);
                this.m_ImagePanel.setBackgroundColor(ImageViewer.this.m_BackgroundColor);
            }

            @Override
            public void cleanUp() {
            }

            @Override
            public void clearPanel() {
                this.m_ImagePanel.clear();
            }
        };
        result.display(token);
        return result;
    }

    @Override
    public boolean displayPanelRequiresScrollPane() {
        return true;
    }
}

