/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.LogEntryWriter;
import adams.core.option.OptionHandler;
import adams.db.LogEntry;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplay;
import adams.flow.sink.logview.AbstractLogEntryDialog;
import adams.flow.sink.logview.DefaultLogEntryDialog;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.tools.LogEntryViewerTableModel;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LogViewer
extends AbstractDisplay {
    private static final long serialVersionUID = -1980631598893105134L;
    protected BaseTableWithButtons m_TableEntries;
    protected JButton m_ButtonDisplay;
    protected JButton m_ButtonSave;
    protected AbstractLogEntryDialog m_Dialog;
    protected transient BaseFileChooser m_BaseFileChooser;
    protected ArrayList<BaseDialog> m_Dialogs;

    @Override
    public String globalInfo() {
        return "Actor that displays LogEntry objects, but doesn't store them in the database.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dialog", "dialog", new DefaultLogEntryDialog());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Dialogs = new ArrayList();
    }

    @Override
    public String getQuickInfo() {
        return super.getQuickInfo() + QuickInfoHelper.toString((OptionHandler)this, "dialog", this.m_Dialog, ", dialog: ");
    }

    public void setDialog(AbstractLogEntryDialog value) {
        this.m_Dialog = value;
        this.reset();
    }

    public AbstractLogEntryDialog getDialog() {
        return this.m_Dialog;
    }

    public String dialogTipText() {
        return "The dialog to use for displaying the log entries.";
    }

    @Override
    protected int getDefaultWidth() {
        return 600;
    }

    @Override
    protected int getDefaultHeight() {
        return 400;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{LogEntry.class};
    }

    @Override
    public void clearPanel() {
        if (this.m_TableEntries != null) {
            ((LogEntryViewerTableModel)this.m_TableEntries.getModel()).clear();
        }
    }

    protected void displayMessage(LogEntry entry) {
        try {
            BaseDialog dialog = this.m_Dialog.create(this, entry);
            this.m_Dialogs.add(dialog);
            dialog.setLocationRelativeTo(this.m_TableEntries);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            this.handleException("Failed to display log entry!", e);
        }
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TableEntries = new BaseTableWithButtons(new LogEntryViewerTableModel());
        this.m_TableEntries.setSelectionMode(2);
        this.m_TableEntries.setAutoResizeMode(0);
        this.m_TableEntries.setInfoVisible(true);
        this.m_TableEntries.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LogViewer.this.m_ButtonDisplay.setEnabled(LogViewer.this.m_TableEntries.getSelectedRowCount() == 1);
            }
        });
        result.add((Component)this.m_TableEntries, "Center");
        this.m_ButtonDisplay = new JButton("Display...");
        this.m_ButtonDisplay.setMnemonic('D');
        this.m_ButtonDisplay.setEnabled(false);
        this.m_ButtonDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = LogViewer.this.m_TableEntries.getSelectedRow();
                LogEntryViewerTableModel model = (LogEntryViewerTableModel)LogViewer.this.m_TableEntries.getModel();
                LogEntry entry = model.getLogEntryAt(row);
                LogViewer.this.displayMessage(entry);
            }
        });
        this.m_TableEntries.addToButtonsPanel(this.m_ButtonDisplay);
        this.m_TableEntries.setDoubleClickButton(this.m_ButtonDisplay);
        this.m_ButtonSave = new JButton("Save...");
        this.m_ButtonSave.setMnemonic('S');
        this.m_ButtonSave.setEnabled(true);
        this.m_ButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VFSJFileChooser.RETURN_TYPE retVal = LogViewer.this.getBaseFileChooser().showSaveDialog(LogViewer.this.m_TableEntries);
                if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
                    return;
                }
                String filename = LogViewer.this.getBaseFileChooser().getSelectedFile().getAbsolutePath();
                LogEntryWriter.rewrite(filename);
                int[] rows = LogViewer.this.m_TableEntries.getSelectedRows();
                LogEntryViewerTableModel model = (LogEntryViewerTableModel)LogViewer.this.m_TableEntries.getModel();
                if (rows.length == 0) {
                    for (int i = 0; i < LogViewer.this.m_TableEntries.getRowCount(); ++i) {
                        LogEntryWriter.write(filename, model.getLogEntryAt(i));
                    }
                } else {
                    for (int i = 0; i < rows.length; ++i) {
                        LogEntryWriter.write(filename, model.getLogEntryAt(rows[i]));
                    }
                }
            }
        });
        this.m_TableEntries.addToButtonsPanel(this.m_ButtonSave);
        this.m_TableEntries.setOptimalColumnWidth();
        return result;
    }

    protected BaseFileChooser getBaseFileChooser() {
        if (this.m_BaseFileChooser == null) {
            BaseFileChooser fileChooser = new BaseFileChooser();
            fileChooser.addChoosableFileFilter(ExtensionFileFilter.getCsvFileFilter());
            ExtensionFileFilter filter = ExtensionFileFilter.getLogFileFilter();
            fileChooser.addChoosableFileFilter(filter);
            fileChooser.setDefaultExtension(filter.getExtensions()[0]);
            fileChooser.setAutoAppendExtension(true);
            fileChooser.setCurrentDirectory(new File("."));
            fileChooser.setSelectedFile(new File(this.getName() + "." + fileChooser.getDefaultExtension()));
        }
        return this.m_BaseFileChooser;
    }

    @Override
    protected void display(Token token) {
        LogEntry entry = (LogEntry)token.getPayload();
        ((LogEntryViewerTableModel)this.m_TableEntries.getModel()).add(entry, true);
        this.m_TableEntries.setOptimalColumnWidth();
    }

    @Override
    protected void cleanUpGUI() {
        while (this.m_Dialogs.size() > 0) {
            this.m_Dialogs.get(0).setVisible(false);
            this.m_Dialogs.get(0).dispose();
            this.m_Dialogs.remove(0);
        }
        super.cleanUpGUI();
    }
}

