/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;

public class CombineVariables
extends AbstractSource {
    private static final long serialVersionUID = -7838881435448178095L;
    protected String m_Expression;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Outputs the expanded string generated from the specified combination expression.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", "");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_OutputToken = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public void setExpression(String value) {
        this.m_Expression = value;
        this.reset();
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The expression to use for combining the variables.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "expression", this.m_Expression);
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.m_OutputToken = new Token(this.getVariables().expand(this.m_Expression));
        return result;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

